/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.http.post;

import com.gmail.berndivader.biene.Helper;
import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Worker;
import com.gmail.berndivader.biene.enums.Tasks;
import com.gmail.berndivader.biene.http.post.IPostTask;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.concurrent.FutureCallback;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class PostTask
extends Worker
implements Callable<HttpResponse>,
IPostTask {
    protected String url;
    protected HttpEntity entity;
    public final CountDownLatch latch;
    public Future<HttpResponse> future;
    protected final HttpPost post;
    protected final Tasks command;
    public boolean failed;

    public PostTask(String url) {
        if (!Helper.client.isRunning()) {
            Helper.client.start();
        }
        this.failed = false;
        this.url = url;
        this.command = Tasks.VARIOUS;
        this.latch = new CountDownLatch(1);
        this.post = new HttpPost(url);
    }

    public PostTask(String url, HttpEntity entity) {
        if (!Helper.client.isRunning()) {
            Helper.client.start();
        }
        this.failed = false;
        this.url = url;
        this.entity = entity;
        this.command = Tasks.VARIOUS;
        this.latch = new CountDownLatch(1);
        this.post = new HttpPost(url);
        this.post.setEntity(this.entity);
    }

    protected void start() {
        if (Helper.client.isRunning()) {
            Helper.executor.submit(this);
        } else {
            Logger.$(this.command + " failed. http_client not running.", false, false);
            this.failed = true;
            this.latch.countDown();
        }
    }

    @Override
    public HttpResponse call() throws Exception {
        this.future = this.execute(this.post);
        this.took();
        return this.future.get(10L, TimeUnit.MINUTES);
    }

    protected Future<HttpResponse> execute(HttpPost post) {
        return Helper.client.execute(post, new FutureCallback<HttpResponse>(){

            @Override
            public void failed(Exception e) {
                PostTask.this.failed = true;
                Logger.$(e, false, false);
                Logger.$(PostTask.this.command + " failed.\nFehlermeldung: " + e.getMessage(), false, false);
                PostTask.this._failed(null);
                PostTask.this.latch.countDown();
            }

            @Override
            public void completed(HttpResponse respond) {
                PostTask.this.failed = false;
                PostTask.this._completed(respond);
                PostTask.this.latch.countDown();
            }

            @Override
            public void cancelled() {
                PostTask.this.failed = true;
                Logger.$(PostTask.this.command + " cancelled", false, false);
                PostTask.this._failed(null);
                PostTask.this.latch.countDown();
            }
        });
    }

    protected static Map<String, String> mapNodes(String node_name, NodeList nodes, Map<String, String> result) {
        int size = nodes.getLength();
        for (int i1 = 0; i1 < size; ++i1) {
            Node node = nodes.item(i1);
            if (node.hasChildNodes()) {
                PostTask.mapNodes(node.getNodeName(), node.getChildNodes(), result);
                continue;
            }
            if (node.getNodeType() != 3) continue;
            result.put(node_name, node.getTextContent().trim());
        }
        return result;
    }
}

