/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.db;

import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.config.Config;
import com.gmail.berndivader.biene.db.QueryBatchTask;
import com.gmail.berndivader.biene.http.post.PostImageUpload;
import com.gmail.berndivader.biene.http.post.PostProcessImages;
import java.io.File;
import java.util.concurrent.TimeUnit;

public class UpdatePicturesTask
extends QueryBatchTask {
    static String start_info = "-- Starte Bilder-Update Task %s...";
    static String scheduled_info = "-- Scheduled Bilder-Update Task %s...";
    static String ende_info = "-- Beende Bilder-Update Task %s.";
    static String ende_error = "-- Bilder-Update Task %s erfolgreich aber fehlerhaft.";
    static String ende_ok = "-- Bilder-Update Task %s erfolgreich.";

    public UpdatePicturesTask() {
        super("", 1);
        this.add();
        Logger.$(String.format(scheduled_info, this.uuid.toString()), false, false);
    }

    @Override
    public Boolean call() throws Exception {
        File[] files;
        Logger.$(String.format(start_info, this.uuid.toString()), false, true);
        boolean failed = false;
        File folder = new File("Bilder/");
        for (File file : files = folder.listFiles()) {
            PostImageUpload upload = new PostImageUpload(Config.data.http_string(), file);
            upload.latch.await(upload.max_minutes, TimeUnit.MINUTES);
            failed = upload.failed;
        }
        boolean repeat = true;
        while (repeat) {
            PostProcessImages process = new PostProcessImages(Config.data.http_string());
            process.latch.await(process.max_minutes, TimeUnit.MINUTES);
            repeat = process.more;
            if (!process.failed) continue;
            failed = true;
            break;
        }
        if (failed) {
            this.failed(null);
        } else {
            this.completed(null);
        }
        Logger.$(String.format(ende_info, this.uuid.toString()), false, false);
        this.latch.countDown();
        return true;
    }

    @Override
    public void completed(Void result) {
        Logger.$(String.format(ende_ok, this.uuid.toString()), false, true);
    }

    @Override
    public void failed(Void result) {
        Logger.$(String.format(ende_error, this.uuid.toString()), false, true);
    }

    @Override
    protected void max_minutes(long max) {
        this.max_minutes = 10L;
    }
}

