/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.db;

import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.config.Config;
import com.gmail.berndivader.biene.db.QueryBatchTask;
import com.gmail.berndivader.biene.http.post.PostImageUpload;
import com.gmail.berndivader.biene.http.post.PostProcessImagesSync;
import java.io.File;
import java.util.concurrent.TimeUnit;

public class UpdatePicturesTask
extends QueryBatchTask {
    static String start_info = "-- Starte Bilder-Update Task %s...";
    static String scheduled_info = "-- Scheduled Bilder-Update Task %s...";
    static String ende_error = "-- Bilder-Update Task %s abgeschlossen aber fehlerhaft.";
    static String ende_ok = "-- Bilder-Update Task %s erfolgreich beendet.";

    public UpdatePicturesTask() {
        super(1);
        this.add();
        Logger.$(String.format(scheduled_info, this.uuid.toString()), false, false);
    }

    @Override
    public Boolean call() throws Exception {
        PostProcessImagesSync process;
        File[] files;
        Logger.$(String.format(start_info, this.uuid.toString()), false, true);
        boolean failed = false;
        File folder = new File("Bilder/");
        for (File file : files = folder.listFiles()) {
            PostImageUpload upload = new PostImageUpload(Config.data.http_string(), file);
            upload.latch.await(upload.max_seconds, TimeUnit.SECONDS);
            failed = upload.failed;
        }
        boolean repeat = true;
        while (repeat && (process = new PostProcessImagesSync(Config.data.http_string())).join() && !process.failed) {
            repeat = process.more;
        }
        if (failed) {
            this.failed(null);
        } else {
            this.completed(null);
        }
        this.latch.countDown();
        return true;
    }

    @Override
    public void completed(Void result) {
        Logger.$(String.format(ende_ok, this.uuid.toString()), false, true);
    }

    @Override
    public void failed(Void result) {
        Logger.$(String.format(ende_error, this.uuid.toString()), false, true);
    }

    @Override
    protected void max_seconds(long max) {
        this.max_seconds = 180L;
    }
}

