/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.http.get;

import com.gmail.berndivader.biene.Helper;
import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Worker;
import com.gmail.berndivader.biene.config.Config;
import com.gmail.berndivader.biene.enums.Tasks;
import com.gmail.berndivader.biene.http.get.IGetTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;

public abstract class GetTaskSync
extends Worker
implements Callable<HttpResponse>,
IGetTask {
    protected final String url;
    protected final Tasks command;
    protected final HttpGet request;
    protected CompletableFuture<Void> completable;
    public boolean failed;

    public GetTaskSync(String url, Tasks command) {
        this.url = url;
        this.command = command;
        this.request = new HttpGet(url.concat(command.get()));
        if (Config.data.cf_enabled()) {
            this.request.setHeader("CF-Access-Client-Id", Config.data.cf_client());
            this.request.setHeader("CF-Access-Client-Secret", Config.data.cf_secret());
        }
        this.request.setHeader("X-Authorization", Config.data.bearer_token());
    }

    @Override
    public HttpResponse call() throws Exception {
        this.failed = false;
        return Helper.syncClient.execute(this.request);
    }

    protected CompletableFuture<HttpResponse> start() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.call();
            }
            catch (Exception e) {
                this.failed = true;
                Logger.$(e);
                return Helper.errorResponse(e);
            }
        }, Helper.executor).orTimeout(this.max_seconds, TimeUnit.SECONDS);
    }

    public boolean done() {
        return this.completable.isDone();
    }

    public boolean cancelled() {
        return this.completable.isCancelled();
    }

    public boolean completedExceptionally() {
        return this.completable.isCompletedExceptionally();
    }

    public boolean join() {
        try {
            this.completable.join();
            return !this.completable.isCancelled() && !this.completable.isCompletedExceptionally();
        }
        catch (Exception e) {
            return false;
        }
    }
}

