/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.config;

import com.gmail.berndivader.biene.config.DefaultValue;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

public class ConfigTypeAdapter<T>
implements JsonDeserializer<T>,
JsonSerializer<T> {
    private final Class<T> clazz;

    public ConfigTypeAdapter(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        return new Gson().toJsonTree(src);
    }

    @Override
    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return this.applyDefaultValues(new Gson().fromJson(json, this.clazz));
    }

    private T applyDefaultValues(T object) {
        for (Field field : this.clazz.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                if (field.get(object) != null || !field.isAnnotationPresent(DefaultValue.class)) continue;
                DefaultValue defaultValue = field.getAnnotation(DefaultValue.class);
                Object value = this.parse(field.getType(), defaultValue.value());
                field.set(object, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Fehler beim setzen der Default-Values in Config", e);
            }
        }
        return object;
    }

    private Object parse(Class<?> type, String value) {
        if (type.equals(Integer.TYPE)) {
            return Integer.parseInt(value);
        }
        if (type.equals(Boolean.TYPE)) {
            return Boolean.parseBoolean(value);
        }
        return value;
    }
}

