/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.http.get;

import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Utils;
import com.gmail.berndivader.biene.config.Config;
import com.gmail.berndivader.biene.enums.Tasks;
import com.gmail.berndivader.biene.http.get.GetTaskSync;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.apache.http.HttpResponse;
import org.w3c.dom.Document;

public class GetInfoSync
extends GetTaskSync {
    public GetInfoSync() {
        super(Config.data.http_string(), Tasks.HTTP_GET_VERSION);
        this.completable = ((CompletableFuture)this.start().thenAccept(response -> {
            if (!this.failed) {
                this._completed((HttpResponse)response);
            } else {
                this._failed((HttpResponse)response);
            }
        })).exceptionally(e -> {
            this.failed = true;
            Logger.$(e);
            return null;
        });
    }

    @Override
    public void _completed(HttpResponse response) {
        Document xml = Utils.XML.getXMLDocument(response);
        if (xml != null) {
            HashMap<String, String> map = Utils.XML.map(xml);
            Utils.XML.CODES code = Utils.XML.CODES.from(map);
            if (Utils.XML.isError(map)) {
                Utils.XML.printError(map);
            } else if (code == Utils.XML.CODES.VERSION) {
                Logger.$(String.format("Shop-Script-Version: %s\nShop-Script-Datum: %s", map.get("SCRIPT_VER"), map.get("SCRIPT_DATE")));
            } else {
                Logger.$(String.format("Login zur Shop-Datenbank fehlgeschlagen!\nError-Code:%s Message:%s\nDetails:%s %s", new Object[]{code, map.get("MESSAGE"), map.get("ACTION"), map.getOrDefault("ERROR", "No further details.")}), false, false);
            }
        } else {
            Logger.$("Keine Verbindung zur Shop-Datenbank!", false, false);
        }
    }

    @Override
    public void _failed(HttpResponse response) {
    }

    @Override
    protected void max_seconds(long max) {
        this.max_seconds = 15L;
    }
}

