/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.http.post;

import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Utils;
import com.gmail.berndivader.biene.enums.Tasks;
import com.gmail.berndivader.biene.http.post.PostTaskSync;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.w3c.dom.Document;

public class PostValidateImageFileSync
extends PostTaskSync {
    private String name;

    public PostValidateImageFileSync(String url, String image_name) {
        super(url);
        if (((String)image_name).toLowerCase().contains(".jpg")) {
            image_name = ((String)image_name).substring(0, ((String)image_name).length() - 4) + ".jpg";
        }
        this.name = image_name;
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addPart("image_name", new StringBody((String)image_name, ContentType.MULTIPART_FORM_DATA));
        builder.addPart("action", new StringBody(Tasks.HTTP_POST_IMAGE_VALIDATE_FILE.action(), ContentType.MULTIPART_FORM_DATA));
        this.post.setEntity(builder.build());
        this.completable = ((CompletableFuture)this.start().thenAccept(this::_completed)).exceptionally(e -> {
            Logger.$(e);
            return null;
        });
    }

    @Override
    public void _completed(HttpResponse response) {
        if (!this.failed) {
            Document xml = Utils.XML.getXMLDocument(response);
            if (xml != null) {
                HashMap<String, String> result = Utils.XML.map(xml);
                if (!Utils.XML.isError(result)) {
                    Utils.XML.CODES code = Utils.XML.CODES.from(result.get("CODE"));
                    if (code.equals((Object)Utils.XML.CODES.FAILED)) {
                        Logger.$("Achtung! Keine Bild-Datei " + this.name + " am Server gefunden.", false, false);
                    }
                } else {
                    this.failed = true;
                    Utils.XML.printError(result);
                }
            } else {
                Logger.$("Validate-Image-File hat ungew\u00f6hnlich geantwortet.", false, true);
            }
        }
    }

    @Override
    public void _failed(HttpResponse response) {
    }

    @Override
    protected void max_seconds(long max) {
        this.max_seconds = 60L;
    }
}

