/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.http.post;

import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Utils;
import com.gmail.berndivader.biene.config.Config;
import com.gmail.berndivader.biene.enums.Tasks;
import com.gmail.berndivader.biene.http.post.PostTaskSync;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.w3c.dom.Document;

public class PostXAuthTokenRequestSync
extends PostTaskSync {
    public PostXAuthTokenRequestSync() {
        super(Config.data.http_string());
        this.post.removeHeaders("X-Authorization");
        this.post.setHeader("X-User", Config.data.shop_user());
        this.post.setHeader("X-Password", Config.data.shop_password());
        this.post.setEntity(MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addPart("action", new StringBody(Tasks.HTTP_POST_XAUTH_TOKEN_REQUEST.action(), ContentType.MULTIPART_FORM_DATA)).build());
        this.completable = ((CompletableFuture)this.start().thenAccept(this::_completed)).exceptionally(e -> {
            Logger.$(e);
            return null;
        });
    }

    @Override
    public void _completed(HttpResponse response) {
        if (!this.failed) {
            Document xml = Utils.XML.getXMLDocument(response);
            if (xml != null) {
                HashMap<String, String> result = Utils.XML.map(xml);
                if (Utils.XML.isError(result)) {
                    this.failed = true;
                    Utils.XML.printError(result);
                } else if (result.get("CODE").equals(Utils.XML.CODES.OK.asStr())) {
                    String token = result.get("TOKEN");
                    Config.data.bearer_token(token);
                    Config.saveConfig();
                    Logger.$("XAuth Token erfolgfreich aktualisiert.");
                }
            } else {
                Logger.$("XAuth Token Request hat ungew\u00f6hnlich geantwortet.", false, true);
            }
        }
    }

    @Override
    public void _failed(HttpResponse response) {
    }

    @Override
    protected void max_seconds(long max) {
        this.max_seconds = 30L;
    }
}

