/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene;

import com.gmail.berndivader.biene.Biene;
import com.gmail.berndivader.biene.Headless;
import com.gmail.berndivader.biene.Utils;
import com.gmail.berndivader.biene.gui.Main;
import com.gmail.berndivader.biene.http.Helper;
import java.awt.EventQueue;
import java.awt.TrayIcon;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;

public class Logger {
    static File error_log = new File(Utils.working_dir.getAbsolutePath().concat("/error.log"));

    public static void $(String text, boolean balloned, boolean http_log) {
        if (http_log && Helper.client.isRunning()) {
            Utils.writeLog(text);
        }
        if (!Biene.no_gui) {
            Logger.awt_log(text, balloned, http_log);
        } else {
            Logger.cli_log(text, balloned, http_log);
        }
    }

    public static void $(String text) {
        Logger.$(text, false, false);
    }

    public static void $(String text, boolean balloned) {
        Logger.$(text, balloned, false);
    }

    public static void $(Exception e) {
        Logger.$(e, false, false);
    }

    public static void $(Exception e, boolean balloned, boolean http_log) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(error_log.getAbsoluteFile(), true)));){
            out.println(sw.toString());
        }
        catch (IOException e1) {
            Logger.$(e1);
        }
        Logger.$("ERROR: ".concat(e.getMessage()), false, false);
        pw.close();
        try {
            sw.close();
        }
        catch (IOException e1) {
            Logger.$(e1);
        }
    }

    static void awt_log(final String text, final boolean balloned, boolean http_log) {
        if (text == null || text.isEmpty()) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                String[] arr = Main.frame.log_area.getText().split("\\n");
                if (arr.length > 80) {
                    String[] arr1 = Arrays.copyOfRange(arr, 50, arr.length);
                    Object trimmed = "";
                    for (int i1 = 0; i1 < arr1.length; ++i1) {
                        trimmed = (String)trimmed + arr1[i1].concat("\n");
                    }
                    Main.frame.log_area.setText((String)trimmed);
                }
                Main.frame.log_area.append(text.concat("\n"));
                if (balloned) {
                    Main.frame.tray_icon.displayMessage("Info", text, TrayIcon.MessageType.NONE);
                }
            }
        });
    }

    static void cli_log(String text, boolean balloned, boolean http_log) {
        if (text != null) {
            Headless.reader.printAbove(text);
        }
    }

    static {
        Logger.$(error_log.getAbsolutePath());
        try {
            error_log.createNewFile();
        }
        catch (IOException e) {
            Logger.$(e);
        }
    }
}

