/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.http.get;

import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Utils;
import com.gmail.berndivader.biene.enums.EventEnum;
import com.gmail.berndivader.biene.http.get.GetTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.w3c.dom.Document;

public class GetInfo
extends GetTask {
    public GetInfo(String url, EventEnum command) {
        super(url, command);
    }

    @Override
    public HttpResponse call() throws Exception {
        Future<HttpResponse> future = this.execute(this.request);
        this.latch.await(10L, TimeUnit.SECONDS);
        if (this.failed) {
            this._failed(future.get());
        } else {
            this._completed(future.get());
        }
        this.took();
        return future.get();
    }

    @Override
    public void _completed(HttpResponse response) {
        Document xml = Utils.getXMLDocument(response);
        if (xml != null) {
            int code = Integer.parseInt(xml.getElementsByTagName("CODE").item(0).getFirstChild().getNodeValue());
            if (code == 111) {
                Logger.$("Shop-Script-Version: " + xml.getElementsByTagName("SCRIPT_VER").item(0).getFirstChild().getNodeValue(), false, true);
                Logger.$("Shop-Script-Datum: " + xml.getElementsByTagName("SCRIPT_DATE").item(0).getFirstChild().getNodeValue(), false, true);
            } else {
                Logger.$("Login zur Shop-Datenbank fehlgeschlagen! Error-Code: " + code, false);
                Logger.$("Message: " + xml.getElementsByTagName("MESSAGE").item(0).getFirstChild().getNodeValue(), false, false);
            }
        } else {
            Logger.$("Keine Verbindung zur Shop-Datenbank!", false, false);
        }
    }

    @Override
    public void _failed(HttpResponse response) {
    }
}

