/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.http.post;

import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Utils;
import com.gmail.berndivader.biene.enums.Tasks;
import com.gmail.berndivader.biene.http.Helper;
import com.gmail.berndivader.biene.http.post.PostTask;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.client.methods.ZeroCopyConsumer;
import org.apache.http.nio.client.methods.ZeroCopyPost;
import org.w3c.dom.Document;

public class PostUploadCSV
extends PostTask {
    File response_file = new File("_tmp");
    ZeroCopyPost post;
    ZeroCopyConsumer<HttpResponse> consumer;

    public PostUploadCSV(String url, File file) throws FileNotFoundException {
        super(url, null);
        this.response_file.deleteOnExit();
        this.post = new ZeroCopyPost(url + "&action=" + Tasks.HTTP_POST_UPLOAD_CSV_FILE.action() + "&file_name=" + file.getName() + "&file_size=" + file.length(), file, ContentType.TEXT_PLAIN){

            @Override
            protected HttpEntityEnclosingRequest createRequest(URI requestURI, HttpEntity entity) {
                HttpEntityEnclosingRequest request = super.createRequest(requestURI, entity);
                return request;
            }
        };
        this.consumer = new ZeroCopyConsumer<HttpResponse>(this.response_file){

            @Override
            protected HttpResponse process(HttpResponse response, File file, ContentType content_type) throws Exception {
                if (response.getStatusLine().getStatusCode() != 200) {
                    PostUploadCSV.this.failed = true;
                    Logger.$(PostUploadCSV.this.command + " failed.\nFehlermeldung: " + response.getStatusLine(), false, true);
                    throw new ClientProtocolException("Upload failed:" + response.getStatusLine());
                }
                PostUploadCSV.this.failed = false;
                return response;
            }
        };
        this.start();
    }

    @Override
    public HttpResponse call() throws Exception {
        Future<HttpResponse> future = this.execute(this.post);
        this.took();
        return future.get(5L, TimeUnit.MINUTES);
    }

    protected Future<HttpResponse> execute(ZeroCopyPost post) {
        return Helper.client.execute(post, this.consumer, new FutureCallback<HttpResponse>(){

            @Override
            public void failed(Exception e) {
                PostUploadCSV.this.failed = true;
                Logger.$(e, false, true);
                Logger.$(PostUploadCSV.this.command + " failed.\nFehlermeldung: " + e.getMessage(), false, true);
                PostUploadCSV.this._failed(null);
                PostUploadCSV.this.latch.countDown();
            }

            @Override
            public void completed(HttpResponse respond) {
                if (PostUploadCSV.this.failed) {
                    PostUploadCSV.this._failed(null);
                } else {
                    PostUploadCSV.this._completed(respond);
                }
                PostUploadCSV.this.latch.countDown();
            }

            @Override
            public void cancelled() {
                PostUploadCSV.this.failed = true;
                Logger.$(PostUploadCSV.this.command + " cancelled", false, true);
                PostUploadCSV.this._failed(null);
                PostUploadCSV.this.latch.countDown();
            }
        });
    }

    @Override
    public void _completed(HttpResponse response) {
        Document xml = Utils.XML.getXMLDocument(response);
        if (xml != null) {
            Map<String, String> result = PostUploadCSV.mapNodes("", xml.getChildNodes(), new HashMap<String, String>());
            String file_name = result.get("OUTCOME");
            Logger.$("CSV-Upload von " + file_name + " " + result.get("MESSAGE"), false, false);
        } else {
            Logger.$("CSV-Upload hat ungew\u00f6hnlich geantwortet.", false, true);
            this._failed(response);
        }
        this.response_file.delete();
    }

    @Override
    public void _failed(HttpResponse response) {
        this.failed = true;
        this.response_file.delete();
    }
}

