/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.db;

import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.config.Config;
import com.gmail.berndivader.biene.db.SimpleResultQuery;
import com.gmail.berndivader.biene.enums.Tasks;
import java.sql.ResultSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class CatalogTree
extends SimpleResultQuery {
    private static final String QUERY = "SELECT c000 AS ID, c001 AS NAME,c002 AS DEPTH FROM t309 WHERE mesocomp='%s' AND mesoyear=%d;";
    public LinkedHashMap<String, Object> tree;

    public CatalogTree() {
        super(String.format(QUERY, Config.data.meso_client(), (Config.data.meso_year() - 1900) * 12), Tasks.UNKOWN, 5L);
    }

    @Override
    public void completed(ResultSet result) {
        this.tree = new LinkedHashMap();
        try {
            while (result.next()) {
                String id = result.getString("ID");
                String name = result.getString("NAME");
                int depth = result.getInt("DEPTH");
                this.add(this.tree, id.split("-"), name, depth, 0);
            }
        }
        catch (Exception e) {
            Logger.$(e);
            this.tree = new LinkedHashMap();
        }
    }

    @Override
    public void failed(Void error) {
        this.tree = new LinkedHashMap();
    }

    private void add(LinkedHashMap<String, Object> map, String[] parts, String name, int depth, int currentDepth) {
        String part;
        if (currentDepth >= parts.length) {
            return;
        }
        String string = part = parts[currentDepth].equals("00000") ? "INFO" : parts[currentDepth];
        if (currentDepth == depth) {
            map.putIfAbsent(part, new LinkedHashMap<String, Integer>(Map.of("NAME", name, "DEPTH", depth)));
        } else {
            map.putIfAbsent(part, new LinkedHashMap());
            Object child = map.get(part);
            if (child instanceof LinkedHashMap) {
                this.add((LinkedHashMap)child, parts, name, depth, currentDepth + 1);
            }
        }
    }
}

