/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.models.KeyBundle;
import com.microsoft.azure.keyvault.models.KeyOperationResult;
import com.microsoft.azure.keyvault.models.KeyVerifyResult;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyEncryptionAlgorithm;
import com.microsoft.azure.keyvault.webkey.JsonWebKeySignatureAlgorithm;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import com.microsoft.sqlserver.jdbc.KeyStoreProviderCommon;
import com.microsoft.sqlserver.jdbc.KeyVaultCredential;
import com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionKeyStoreProvider;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerKeyVaultAuthenticationCallback;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;

public class SQLServerColumnEncryptionAzureKeyVaultProvider
extends SQLServerColumnEncryptionKeyStoreProvider {
    private static final Logger akvLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionAzureKeyVaultProvider");
    String name = "AZURE_KEY_VAULT";
    private final String baseUrl = "https://{vaultBaseUrl}";
    private static final String MSSQL_JDBC_PROPERTIES = "mssql-jdbc.properties";
    private static final String AKV_TRUSTED_ENDPOINTS_KEYWORD = "AKVTrustedEndpoints";
    private static final List<String> akvTrustedEndpoints = SQLServerColumnEncryptionAzureKeyVaultProvider.getTrustedEndpoints();
    private final String rsaEncryptionAlgorithmWithOAEPForAKV = "RSA-OAEP";
    private final byte[] firstVersion = new byte[]{1};
    private KeyVaultClient keyVaultClient;
    private KeyVaultCredential credentials;

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Deprecated
    public SQLServerColumnEncryptionAzureKeyVaultProvider(SQLServerKeyVaultAuthenticationCallback authenticationCallback, ExecutorService executorService) throws SQLServerException {
        this(authenticationCallback);
    }

    public SQLServerColumnEncryptionAzureKeyVaultProvider(SQLServerKeyVaultAuthenticationCallback authenticationCallback) throws SQLServerException {
        if (null == authenticationCallback) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_NullValue"));
            Object[] msgArgs1 = new Object[]{"SQLServerKeyVaultAuthenticationCallback"};
            throw new SQLServerException(form.format(msgArgs1), null);
        }
        this.credentials = new KeyVaultCredential(authenticationCallback);
        RestClient restClient = new RestClient.Builder(new OkHttpClient.Builder(), new Retrofit.Builder()).withBaseUrl("https://{vaultBaseUrl}").withCredentials((ServiceClientCredentials)this.credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).build();
        this.keyVaultClient = new KeyVaultClient(restClient);
    }

    public SQLServerColumnEncryptionAzureKeyVaultProvider(String clientId, String clientKey) throws SQLServerException {
        this.credentials = new KeyVaultCredential(clientId, clientKey);
        this.keyVaultClient = new KeyVaultClient((ServiceClientCredentials)this.credentials);
    }

    @Override
    public byte[] decryptColumnEncryptionKey(String masterKeyPath, String encryptionAlgorithm, byte[] encryptedColumnEncryptionKey) throws SQLServerException {
        this.ValidateNonEmptyAKVPath(masterKeyPath);
        if (null == encryptedColumnEncryptionKey) {
            throw new SQLServerException(SQLServerException.getErrString("R_NullEncryptedColumnEncryptionKey"), null);
        }
        if (0 == encryptedColumnEncryptionKey.length) {
            throw new SQLServerException(SQLServerException.getErrString("R_EmptyEncryptedColumnEncryptionKey"), null);
        }
        encryptionAlgorithm = this.validateEncryptionAlgorithm(encryptionAlgorithm);
        int keySizeInBytes = this.getAKVKeySize(masterKeyPath);
        if (encryptedColumnEncryptionKey[0] != this.firstVersion[0]) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_InvalidEcryptionAlgorithmVersion"));
            Object[] msgArgs = new Object[]{String.format("%02X ", encryptedColumnEncryptionKey[0]), String.format("%02X ", this.firstVersion[0])};
            throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
        }
        int currentIndex = this.firstVersion.length;
        short keyPathLength = this.convertTwoBytesToShort(encryptedColumnEncryptionKey, currentIndex);
        short cipherTextLength = this.convertTwoBytesToShort(encryptedColumnEncryptionKey, currentIndex += 2);
        currentIndex += 2;
        currentIndex += keyPathLength;
        if (cipherTextLength != keySizeInBytes) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_AKVKeyLengthError"));
            Object[] msgArgs = new Object[]{cipherTextLength, keySizeInBytes, masterKeyPath};
            throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
        }
        int signatureLength = encryptedColumnEncryptionKey.length - currentIndex - cipherTextLength;
        if (signatureLength != keySizeInBytes) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_AKVSignatureLengthError"));
            Object[] msgArgs = new Object[]{signatureLength, keySizeInBytes, masterKeyPath};
            throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
        }
        byte[] cipherText = new byte[cipherTextLength];
        System.arraycopy(encryptedColumnEncryptionKey, currentIndex, cipherText, 0, cipherTextLength);
        byte[] signature = new byte[signatureLength];
        System.arraycopy(encryptedColumnEncryptionKey, currentIndex += cipherTextLength, signature, 0, signatureLength);
        byte[] hash = new byte[encryptedColumnEncryptionKey.length - signature.length];
        System.arraycopy(encryptedColumnEncryptionKey, 0, hash, 0, encryptedColumnEncryptionKey.length - signature.length);
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SQLServerException(SQLServerException.getErrString("R_NoSHA256Algorithm"), e);
        }
        md.update(hash);
        byte[] dataToVerify = md.digest();
        if (null == dataToVerify) {
            throw new SQLServerException(SQLServerException.getErrString("R_HashNull"), null);
        }
        if (!this.AzureKeyVaultVerifySignature(dataToVerify, signature, masterKeyPath)) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_CEKSignatureNotMatchCMK"));
            Object[] msgArgs = new Object[]{masterKeyPath};
            throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
        }
        byte[] decryptedCEK = this.AzureKeyVaultUnWrap(masterKeyPath, encryptionAlgorithm, cipherText);
        return decryptedCEK;
    }

    private short convertTwoBytesToShort(byte[] input, int index) throws SQLServerException {
        if (index + 1 >= input.length) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_ByteToShortConversion"), null, 0, false);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(input[index]);
        byteBuffer.put(input[index + 1]);
        short shortVal = byteBuffer.getShort(0);
        return shortVal;
    }

    @Override
    public byte[] encryptColumnEncryptionKey(String masterKeyPath, String encryptionAlgorithm, byte[] columnEncryptionKey) throws SQLServerException {
        this.ValidateNonEmptyAKVPath(masterKeyPath);
        if (null == columnEncryptionKey) {
            throw new SQLServerException(SQLServerException.getErrString("R_NullColumnEncryptionKey"), null);
        }
        if (0 == columnEncryptionKey.length) {
            throw new SQLServerException(SQLServerException.getErrString("R_EmptyCEK"), null);
        }
        encryptionAlgorithm = this.validateEncryptionAlgorithm(encryptionAlgorithm);
        int keySizeInBytes = this.getAKVKeySize(masterKeyPath);
        byte[] version = new byte[]{this.firstVersion[0]};
        byte[] masterKeyPathBytes = masterKeyPath.toLowerCase(Locale.ENGLISH).getBytes(StandardCharsets.UTF_16LE);
        byte[] keyPathLength = new byte[]{(byte)((short)masterKeyPathBytes.length & 0xFF), (byte)((short)masterKeyPathBytes.length >> 8 & 0xFF)};
        byte[] cipherText = this.AzureKeyVaultWrap(masterKeyPath, encryptionAlgorithm, columnEncryptionKey);
        byte[] cipherTextLength = new byte[]{(byte)((short)cipherText.length & 0xFF), (byte)((short)cipherText.length >> 8 & 0xFF)};
        if (cipherText.length != keySizeInBytes) {
            throw new SQLServerException(SQLServerException.getErrString("R_CipherTextLengthNotMatchRSASize"), null);
        }
        byte[] dataToHash = new byte[version.length + keyPathLength.length + cipherTextLength.length + masterKeyPathBytes.length + cipherText.length];
        int destinationPosition = version.length;
        System.arraycopy(version, 0, dataToHash, 0, version.length);
        System.arraycopy(keyPathLength, 0, dataToHash, destinationPosition, keyPathLength.length);
        System.arraycopy(cipherTextLength, 0, dataToHash, destinationPosition += keyPathLength.length, cipherTextLength.length);
        System.arraycopy(masterKeyPathBytes, 0, dataToHash, destinationPosition += cipherTextLength.length, masterKeyPathBytes.length);
        System.arraycopy(cipherText, 0, dataToHash, destinationPosition += masterKeyPathBytes.length, cipherText.length);
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SQLServerException(SQLServerException.getErrString("R_NoSHA256Algorithm"), e);
        }
        md.update(dataToHash);
        byte[] dataToSign = md.digest();
        byte[] signedHash = this.AzureKeyVaultSignHashedData(dataToSign, masterKeyPath);
        if (signedHash.length != keySizeInBytes) {
            throw new SQLServerException(SQLServerException.getErrString("R_SignedHashLengthError"), null);
        }
        if (!this.AzureKeyVaultVerifySignature(dataToSign, signedHash, masterKeyPath)) {
            throw new SQLServerException(SQLServerException.getErrString("R_InvalidSignatureComputed"), null);
        }
        int encryptedColumnEncryptionKeyLength = version.length + cipherTextLength.length + keyPathLength.length + cipherText.length + masterKeyPathBytes.length + signedHash.length;
        byte[] encryptedColumnEncryptionKey = new byte[encryptedColumnEncryptionKeyLength];
        int currentIndex = 0;
        System.arraycopy(version, 0, encryptedColumnEncryptionKey, currentIndex, version.length);
        System.arraycopy(keyPathLength, 0, encryptedColumnEncryptionKey, currentIndex += version.length, keyPathLength.length);
        System.arraycopy(cipherTextLength, 0, encryptedColumnEncryptionKey, currentIndex += keyPathLength.length, cipherTextLength.length);
        System.arraycopy(masterKeyPathBytes, 0, encryptedColumnEncryptionKey, currentIndex += cipherTextLength.length, masterKeyPathBytes.length);
        System.arraycopy(cipherText, 0, encryptedColumnEncryptionKey, currentIndex += masterKeyPathBytes.length, cipherText.length);
        System.arraycopy(signedHash, 0, encryptedColumnEncryptionKey, currentIndex += cipherText.length, signedHash.length);
        return encryptedColumnEncryptionKey;
    }

    private String validateEncryptionAlgorithm(String encryptionAlgorithm) throws SQLServerException {
        if (null == encryptionAlgorithm) {
            throw new SQLServerException(null, SQLServerException.getErrString("R_NullKeyEncryptionAlgorithm"), null, 0, false);
        }
        if ("RSA_OAEP".equalsIgnoreCase(encryptionAlgorithm)) {
            encryptionAlgorithm = "RSA-OAEP";
        }
        if (!"RSA-OAEP".equalsIgnoreCase(encryptionAlgorithm.trim())) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_InvalidKeyEncryptionAlgorithm"));
            Object[] msgArgs = new Object[]{encryptionAlgorithm, "RSA-OAEP"};
            throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
        }
        return encryptionAlgorithm;
    }

    private void ValidateNonEmptyAKVPath(String masterKeyPath) throws SQLServerException {
        if (null == masterKeyPath || masterKeyPath.trim().isEmpty()) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_AKVPathNull"));
            Object[] msgArgs = new Object[]{masterKeyPath};
            throw new SQLServerException(null, form.format(msgArgs), null, 0, false);
        }
        URI parsedUri = null;
        try {
            parsedUri = new URI(masterKeyPath);
            String host = parsedUri.getHost();
            if (null != host) {
                host = host.toLowerCase(Locale.ENGLISH);
            }
            for (String endpoint : akvTrustedEndpoints) {
                if (null == host || !host.endsWith(endpoint)) continue;
                return;
            }
        }
        catch (URISyntaxException e) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_AKVURLInvalid"));
            Object[] msgArgs = new Object[]{masterKeyPath};
            throw new SQLServerException(form.format(msgArgs), null, 0, (Throwable)e);
        }
        MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_AKVMasterKeyPathInvalid"));
        Object[] msgArgs = new Object[]{masterKeyPath};
        throw new SQLServerException(null, form.format(msgArgs), null, 0, false);
    }

    private byte[] AzureKeyVaultWrap(String masterKeyPath, String encryptionAlgorithm, byte[] columnEncryptionKey) throws SQLServerException {
        if (null == columnEncryptionKey) {
            throw new SQLServerException(SQLServerException.getErrString("R_CEKNull"), null);
        }
        JsonWebKeyEncryptionAlgorithm jsonEncryptionAlgorithm = new JsonWebKeyEncryptionAlgorithm(encryptionAlgorithm);
        KeyOperationResult wrappedKey = this.keyVaultClient.wrapKey(masterKeyPath, jsonEncryptionAlgorithm, columnEncryptionKey);
        return wrappedKey.result();
    }

    private byte[] AzureKeyVaultUnWrap(String masterKeyPath, String encryptionAlgorithm, byte[] encryptedColumnEncryptionKey) throws SQLServerException {
        if (null == encryptedColumnEncryptionKey) {
            throw new SQLServerException(SQLServerException.getErrString("R_EncryptedCEKNull"), null);
        }
        if (0 == encryptedColumnEncryptionKey.length) {
            throw new SQLServerException(SQLServerException.getErrString("R_EmptyEncryptedCEK"), null);
        }
        JsonWebKeyEncryptionAlgorithm jsonEncryptionAlgorithm = new JsonWebKeyEncryptionAlgorithm(encryptionAlgorithm);
        KeyOperationResult unwrappedKey = this.keyVaultClient.unwrapKey(masterKeyPath, jsonEncryptionAlgorithm, encryptedColumnEncryptionKey);
        return unwrappedKey.result();
    }

    private byte[] AzureKeyVaultSignHashedData(byte[] dataToSign, String masterKeyPath) throws SQLServerException {
        assert (null != dataToSign && 0 != dataToSign.length);
        KeyOperationResult signedData = this.keyVaultClient.sign(masterKeyPath, JsonWebKeySignatureAlgorithm.RS256, dataToSign);
        return signedData.result();
    }

    private boolean AzureKeyVaultVerifySignature(byte[] dataToVerify, byte[] signature, String masterKeyPath) throws SQLServerException {
        assert (null != dataToVerify && 0 != dataToVerify.length);
        assert (null != signature && 0 != signature.length);
        KeyVerifyResult valid = this.keyVaultClient.verify(masterKeyPath, JsonWebKeySignatureAlgorithm.RS256, dataToVerify, signature);
        return valid.value();
    }

    private int getAKVKeySize(String masterKeyPath) throws SQLServerException {
        KeyBundle retrievedKey = this.keyVaultClient.getKey(masterKeyPath);
        if (null == retrievedKey) {
            String[] keyTokens = masterKeyPath.split("/");
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_AKVKeyNotFound"));
            Object[] msgArgs = new Object[]{keyTokens[keyTokens.length - 1]};
            throw new SQLServerException(null, form.format(msgArgs), null, 0, false);
        }
        if (!"RSA".equalsIgnoreCase(retrievedKey.key().kty().toString()) && !"RSA-HSM".equalsIgnoreCase(retrievedKey.key().kty().toString())) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_NonRSAKey"));
            Object[] msgArgs = new Object[]{retrievedKey.key().kty().toString()};
            throw new SQLServerException(null, form.format(msgArgs), null, 0, false);
        }
        return retrievedKey.key().n().length;
    }

    @Override
    public boolean verifyColumnMasterKeyMetadata(String masterKeyPath, boolean allowEnclaveComputations, byte[] signature) throws SQLServerException {
        if (!allowEnclaveComputations) {
            return false;
        }
        KeyStoreProviderCommon.validateNonEmptyMasterKeyPath(masterKeyPath);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(this.name.toLowerCase().getBytes(StandardCharsets.UTF_16LE));
            md.update(masterKeyPath.toLowerCase().getBytes(StandardCharsets.UTF_16LE));
            md.update("true".getBytes(StandardCharsets.UTF_16LE));
            byte[] dataToVerify = md.digest();
            if (null == dataToVerify) {
                throw new SQLServerException(SQLServerException.getErrString("R_HashNull"), null);
            }
            byte[] signedHash = this.AzureKeyVaultSignHashedData(dataToVerify, masterKeyPath);
            if (null == signedHash) {
                throw new SQLServerException(SQLServerException.getErrString("R_SignedHashLengthError"), null);
            }
            return this.AzureKeyVaultVerifySignature(dataToVerify, signature, masterKeyPath);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SQLServerException(SQLServerException.getErrString("R_NoSHA256Algorithm"), e);
        }
    }

    private static List<String> getTrustedEndpoints() {
        String endpoints;
        Properties mssqlJdbcProperties = SQLServerColumnEncryptionAzureKeyVaultProvider.getMssqlJdbcProperties();
        ArrayList<String> trustedEndpoints = new ArrayList<String>();
        boolean append = true;
        if (null != mssqlJdbcProperties && null != (endpoints = mssqlJdbcProperties.getProperty(AKV_TRUSTED_ENDPOINTS_KEYWORD)) && !endpoints.isBlank()) {
            String[] entries;
            if (';' != (endpoints = endpoints.trim()).charAt(0)) {
                append = false;
            } else {
                endpoints = endpoints.substring(1);
            }
            for (String entry : entries = endpoints.split(";")) {
                if (null == entry || entry.isBlank()) continue;
                trustedEndpoints.add(entry.trim());
            }
        }
        if (append) {
            trustedEndpoints.add("vault.azure.net");
            trustedEndpoints.add("vault.azure.cn");
            trustedEndpoints.add("vault.usgovcloudapi.net");
            trustedEndpoints.add("vault.microsoftazure.de");
        }
        return trustedEndpoints;
    }

    private static Properties getMssqlJdbcProperties() {
        Properties props;
        block7: {
            props = null;
            try (FileInputStream in = new FileInputStream(MSSQL_JDBC_PROPERTIES);){
                props = new Properties();
                props.load(in);
            }
            catch (IOException e) {
                if (!akvLogger.isLoggable(Level.FINER)) break block7;
                akvLogger.finer("Unable to load the mssql-jdbc.properties file: " + e);
            }
        }
        return null != props && !props.isEmpty() ? props : null;
    }
}

