/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj;

import com.mysql.cj.BatchVisitor;
import com.mysql.cj.util.StringUtils;
import java.util.LinkedList;

public class AppendingBatchVisitor
implements BatchVisitor {
    LinkedList<byte[]> statementComponents = new LinkedList();

    @Override
    public BatchVisitor append(byte[] values2) {
        this.statementComponents.addLast(values2);
        return this;
    }

    @Override
    public BatchVisitor increment() {
        return this;
    }

    @Override
    public BatchVisitor decrement() {
        this.statementComponents.removeLast();
        return this;
    }

    @Override
    public BatchVisitor merge(byte[] front, byte[] back) {
        int mergedLength = front.length + back.length;
        byte[] merged = new byte[mergedLength];
        System.arraycopy(front, 0, merged, 0, front.length);
        System.arraycopy(back, 0, merged, front.length, back.length);
        this.statementComponents.addLast(merged);
        return this;
    }

    @Override
    public BatchVisitor mergeWithLast(byte[] values2) {
        if (this.statementComponents.isEmpty()) {
            return this.append(values2);
        }
        return this.merge(this.statementComponents.removeLast(), values2);
    }

    public byte[][] getStaticSqlStrings() {
        byte[][] asBytes = new byte[this.statementComponents.size()][];
        this.statementComponents.toArray((T[])asBytes);
        return asBytes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (byte[] comp : this.statementComponents) {
            sb.append(StringUtils.toString(comp));
        }
        return sb.toString();
    }
}

