/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.heewhomee.database;

import com.gmail.berndivader.heewhomee.Console;
import com.gmail.berndivader.heewhomee.Discord;
import com.gmail.berndivader.heewhomee.HeeWhooMee;
import com.gmail.berndivader.heewhomee.Helper;
import io.github.furstenheim.CopyDown;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;

public abstract class Worker<T>
implements Callable<T> {
    private CopyDown converter = new CopyDown();
    public String lastQuestion = "";
    protected static Pattern pattern = Pattern.compile("@(.*?) ");
    protected String query;
    protected String table;
    protected String filter;
    protected StringBuilder builder;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getSQLResult(String[] temp) {
        if (temp.length > 0) {
            this.table = temp[0].trim();
            this.filter = temp.length > 1 ? temp[1].trim().substring(0, temp[1].length() < HeeWhooMee.config.maxQuestionSize ? temp[1].length() : HeeWhooMee.config.maxQuestionSize) : "";
            switch (this.table.charAt(0)) {
                case 's': {
                    this.table = "skills";
                    break;
                }
                case 'c': {
                    this.table = "conditions";
                    break;
                }
                case 't': {
                    this.table = "targeters";
                    break;
                }
                case 'g': {
                    this.table = "goals";
                    break;
                }
                case 'p': {
                    this.table = "priority";
                    break;
                }
                default: {
                    this.table = "help";
                    this.filter = this.filter.isEmpty() || this.filter.charAt(0) != 'd' ? "Commands" : "Downloads";
                }
            }
            this.lastQuestion = "!".concat(this.table).concat(" ").concat(this.filter);
        }
        this.builder = new StringBuilder();
        try (Connection connection = Helper.getNewDatabaseConnection();){
            boolean secondRun = false;
            while (true) {
                String sql = "select * from ".concat(this.table).concat(" where name like '").concat(this.filter).concat("' order by name ASC;");
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    ResultSet result;
                    block36: {
                        block35: {
                            result = statement.executeQuery();
                            try {
                                int hits = 0;
                                if (!result.last()) break block35;
                                hits = result.getRow();
                                result.beforeFirst();
                                if (hits == 1) {
                                    this.matchOne(result);
                                } else {
                                    this.matchMore(result, hits);
                                }
                                if (result == null) return this.builder.toString();
                            }
                            catch (Throwable throwable) {
                                if (result == null) throw throwable;
                                try {
                                    result.close();
                                    throw throwable;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            result.close();
                            return this.builder.toString();
                        }
                        if (secondRun) break block36;
                        secondRun = true;
                        this.filter = "%".concat(this.filter).concat("%");
                        if (result == null) continue;
                        result.close();
                        continue;
                    }
                    this.builder.append("Sorry, nothing found. ");
                    if (result == null) return this.builder.toString();
                    result.close();
                    return this.builder.toString();
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            Console.err(e.getMessage(), true, e);
        }
        return this.builder.toString();
    }

    protected String getAiResult(String contentRaw) {
        String question;
        String[] parse = pattern.split(contentRaw.trim());
        String answer = "";
        if (parse.length > 1 && (question = parse[1].trim()).length() > 0) {
            try {
                answer = this.converter.convert(Discord.instance.aiSession.think(question));
            }
            catch (Exception e) {
                Console.err(e.getMessage(), true, e);
            }
        }
        return answer;
    }

    private void matchMore(ResultSet result, int hits) throws SQLException {
        this.builder.append("**").append(hits).append(" hits!** Need details? Precise your request! You might search for:```\n");
        int c = 1;
        while (result.next()) {
            this.builder.append(result.getString("name")).append(c < hits ? ", " : ".```\n");
            ++c;
        }
    }

    private void matchOne(ResultSet result) throws SQLException {
        if (result.next()) {
            this.builder.append("Here we go:\n```Markdown\n#").append(result.getString("name")).append("\n#");
            if (this.table.equals("help")) {
                this.builder.append(result.getString("syntax").concat("```\n"));
            } else {
                this.builder.append("[Syntax:](").append(result.getString("syntax")).append(")\n\nUsage:\n======\n").append(result.getString("description")).append("\n[Dependings:](").append(result.getString("addon")).append(")```\n");
            }
        }
    }

    @Override
    public abstract T call() throws Exception;
}

