/*
 * Decompiled with CFR 0.152.
 */
package io.github.furstenheim;

import io.github.furstenheim.CopyNode;
import io.github.furstenheim.NodeUtils;
import java.util.regex.Pattern;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

class WhitespaceCollapser {
    WhitespaceCollapser() {
    }

    void collapse(Node element) {
        if (element.childNodeSize() == 0 || this.isPre(element)) {
            return;
        }
        TextNode prevText = null;
        boolean prevVoid = false;
        Node prev = null;
        Node node = this.next(prev, element);
        while (node != element) {
            block8: {
                block9: {
                    block10: {
                        block7: {
                            if (!NodeUtils.isNodeType3(node) && !NodeUtils.isNodeType4(node)) break block7;
                            TextNode textNode = (TextNode)node;
                            String value = textNode.attributes().get("#text").replaceAll("[ \\r\\n\\t]+", " ");
                            if ((prevText == null || Pattern.compile(" $").matcher(prevText.text()).find()) && !prevVoid && value.charAt(0) == ' ') {
                                value = value.substring(1);
                            }
                            if (value.length() == 0) {
                                node = this.remove(node);
                                continue;
                            }
                            TextNode newNode = new TextNode(value);
                            node.replaceWith(newNode);
                            prevText = newNode;
                            node = newNode;
                            break block8;
                        }
                        if (!NodeUtils.isNodeType1(node)) break block9;
                        if (!this.isBlock(node)) break block10;
                        if (prevText != null) {
                            prevText.text(prevText.text().replaceAll(" $", ""));
                        }
                        prevText = null;
                        prevVoid = false;
                        break block8;
                    }
                    if (!this.isVoid(node)) break block8;
                    prevText = null;
                    prevVoid = true;
                    break block8;
                }
                node = this.remove(node);
                continue;
            }
            Node nextNode = this.next(prev, node);
            prev = node;
            node = nextNode;
        }
        if (prevText != null) {
            prevText.text(prevText.text().replaceAll(" $", ""));
            if (prevText.text() == null) {
                this.remove(prevText);
            }
        }
    }

    private Node remove(Node node) {
        Node next = node.nextSibling() != null ? node.nextSibling() : node.parentNode();
        node.remove();
        return next;
    }

    private Node next(Node prev, Node current) {
        if (prev != null && prev.parent() == current || this.isPre(current)) {
            return current.nextSibling() != null ? current.nextSibling() : current.parentNode();
        }
        if (current.childNodeSize() != 0) {
            return current.childNode(0);
        }
        if (current.nextSibling() != null) {
            return current.nextSibling();
        }
        return current.parentNode();
    }

    private boolean isPre(Node element) {
        return element.nodeName().equals("pre");
    }

    private boolean isBlock(Node element) {
        return CopyNode.isBlock(element) || element.nodeName().equals("br");
    }

    private boolean isVoid(Node element) {
        return CopyNode.isVoid(element);
    }
}

