/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.interactions.modals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.ItemComponent;
import net.dv8tion.jda.api.utils.data.SerializableData;
import net.dv8tion.jda.internal.interactions.modal.ModalImpl;
import net.dv8tion.jda.internal.utils.Checks;

public interface Modal
extends SerializableData {
    public static final int MAX_COMPONENTS = 5;
    public static final int MAX_ID_LENGTH = 100;
    public static final int MAX_TITLE_LENGTH = 45;

    @Nonnull
    public String getId();

    @Nonnull
    public String getTitle();

    @Nonnull
    public List<ActionRow> getActionRows();

    @Nonnull
    default public Builder createCopy() {
        return new Builder(this.getId(), this.getTitle()).addActionRows(this.getActionRows());
    }

    @Nonnull
    @CheckReturnValue
    public static Builder create(@Nonnull String customId, @Nonnull String title) {
        return new Builder(customId, title);
    }

    public static class Builder {
        private final List<ActionRow> components = new ArrayList<ActionRow>(5);
        private String id;
        private String title;

        protected Builder(@Nonnull String customId, @Nonnull String title) {
            this.setId(customId);
            this.setTitle(title);
        }

        @Nonnull
        public Builder setId(@Nonnull String customId) {
            Checks.notBlank(customId, "ID");
            Checks.notLonger(customId, 100, "ID");
            this.id = customId;
            return this;
        }

        @Nonnull
        public Builder setTitle(@Nonnull String title) {
            Checks.notBlank(title, "Title");
            Checks.notLonger(title, 45, "Title");
            this.title = title;
            return this;
        }

        @Nonnull
        public Builder addActionRows(ActionRow ... actionRows) {
            Checks.noneNull(actionRows, "Action Rows");
            return this.addActionRows(Arrays.asList(actionRows));
        }

        @Nonnull
        public Builder addActionRows(@Nonnull Collection<? extends ActionRow> actionRows) {
            Checks.noneNull(actionRows, "Components");
            Checks.checkComponents("Some components are incompatible with Modals", actionRows, component -> component.getType().isModalCompatible());
            this.components.addAll(actionRows);
            return this;
        }

        @Nonnull
        public Builder addActionRow(@Nonnull Collection<? extends ItemComponent> components) {
            return this.addActionRows(ActionRow.of(components));
        }

        @Nonnull
        public Builder addActionRow(ItemComponent ... components) {
            return this.addActionRows(ActionRow.of(components));
        }

        @Nonnull
        public List<ActionRow> getActionRows() {
            return this.components;
        }

        @Nonnull
        public String getTitle() {
            return this.title;
        }

        @Nonnull
        public String getId() {
            return this.id;
        }

        @Nonnull
        public Modal build() {
            Checks.check(!this.components.isEmpty(), "Cannot make a modal without components!");
            Checks.check(this.components.size() <= 5, "Cannot make a modal with more than 5 components!");
            return new ModalImpl(this.id, this.title, this.components);
        }
    }
}

