/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.heewhomee;

import com.gmail.berndivader.heewhomee.Console;
import com.gmail.berndivader.heewhomee.HeeWhooMee;
import com.gmail.berndivader.heewhomee.Helper;
import com.gmail.berndivader.heewhomee.ai.BotSession;
import com.gmail.berndivader.heewhomee.database.DiscordRequest;
import java.util.EnumSet;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.SelfUser;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.events.session.SessionDisconnectEvent;
import net.dv8tion.jda.api.events.session.SessionRecreateEvent;
import net.dv8tion.jda.api.events.session.SessionResumeEvent;
import net.dv8tion.jda.api.events.session.ShutdownEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.requests.GatewayIntent;

public class Discord {
    public static Discord instance;
    private static boolean connected;
    private static int connectRetries;
    public BotSession aiSession;
    private final JDA jda;
    private SelfUser selfUser;

    public static void createNewDiscordSession() {
        if (instance != null) {
            instance.unregisterHandlers();
            instance.close();
            if (!connected && connectRetries < 5) {
                ++connectRetries;
                instance = new Discord();
            }
        } else {
            instance = new Discord();
        }
    }

    public Discord() {
        ++connectRetries;
        this.jda = JDABuilder.createLight(HeeWhooMee.config.token, EnumSet.of(GatewayIntent.DIRECT_MESSAGES, GatewayIntent.GUILD_MESSAGES, GatewayIntent.MESSAGE_CONTENT)).addEventListeners(new Listener()).setActivity(Activity.competing("is back again!")).build();
        if (HeeWhooMee.config.pandoraId != null && !HeeWhooMee.config.pandoraId.isEmpty()) {
            this.aiSession = new BotSession(HeeWhooMee.config.pandoraId);
        }
    }

    public static void setActivity(String str) {
        Discord.instance.jda.getPresence().setActivity(Activity.competing(str));
    }

    public void unregisterHandlers() {
        this.jda.cancelRequests();
        this.jda.removeEventListener(this);
    }

    public void close() {
        this.jda.shutdownNow();
    }

    static {
        connected = false;
        connectRetries = 0;
    }

    private class Listener
    extends ListenerAdapter {
        private Listener() {
        }

        @Override
        public void onReady(ReadyEvent event) {
            connectRetries = 0;
            connected = true;
            Console.out("Connected to discord", true);
            Discord.this.jda.setAutoReconnect(true);
            Discord.this.selfUser = Discord.this.jda.getSelfUser();
        }

        @Override
        public void onSessionDisconnect(SessionDisconnectEvent event) {
            connected = false;
            Console.out("Connection to discord lost.");
        }

        @Override
        public void onSessionResume(SessionResumeEvent event) {
            connected = true;
            Console.out("Reconnected to discord", true);
        }

        @Override
        public void onSessionRecreate(SessionRecreateEvent event) {
            connected = true;
            Console.out("Recreated discord connection", true);
        }

        @Override
        public void onMessageReceived(MessageReceivedEvent event) {
            Message message = event.getMessage();
            String content = message.getContentStripped();
            if (content.isEmpty()) {
                return;
            }
            char test = content.charAt(0);
            int len = content.length();
            if (test == '!' && len > 1 || test == '@' && message.getMentions().getUsers().contains(Discord.this.selfUser)) {
                if (len > HeeWhooMee.config.maxQuestionSize) {
                    content = content.substring(0, HeeWhooMee.config.maxQuestionSize);
                }
                Helper.executor.submit(new DiscordRequest(message, content, test == '@'));
            }
        }

        @Override
        public void onShutdown(ShutdownEvent event) {
            connected = false;
            if (!HeeWhooMee.quit) {
                Discord.createNewDiscordSession();
            }
        }
    }
}

