/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.animatorstands;

import com.gmail.berndivader.animatorstands.AbstractTriggeredSkill;
import com.gmail.berndivader.animatorstands.AnimatorStands;
import com.gmail.berndivader.animatorstands.ArmorStandAnimator;
import com.gmail.berndivader.animatorstands.ArmorStandUtils;
import com.gmail.berndivader.animatorstands.conditions.ArmorStandIsAnimator;
import com.gmail.berndivader.animatorstands.conditions.ArmorStandPauseCondition;
import com.gmail.berndivader.animatorstands.conditions.ArmorStandaiMobTargetDistance;
import com.gmail.berndivader.animatorstands.mechanics.ArmorStandChangeAnimMechanic;
import com.gmail.berndivader.animatorstands.mechanics.ArmorStandInitMechanic;
import com.gmail.berndivader.animatorstands.mechanics.ArmorStandLookAtMechanic;
import com.gmail.berndivader.animatorstands.mechanics.ArmorStandPauseMechanic;
import com.gmail.berndivader.animatorstands.mechanics.ArmorStandRunMechanic;
import com.gmail.berndivader.animatorstands.mechanics.ArmorStandUnloadMechanic;
import com.gmail.berndivader.animatorstands.targeters.AiMobTargeter;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.skills.ISkillMechanic;
import io.lumine.mythic.api.skills.conditions.ISkillCondition;
import io.lumine.mythic.api.skills.targeters.ISkillTargeter;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicConditionLoadEvent;
import io.lumine.mythic.bukkit.events.MythicMechanicLoadEvent;
import io.lumine.mythic.bukkit.events.MythicMobDeathEvent;
import io.lumine.mythic.bukkit.events.MythicTargeterLoadEvent;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillTriggers;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.scheduler.BukkitRunnable;

public class MythicMobsEvents
implements Listener {
    public MythicMobsEvents() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, AnimatorStands.inst());
    }

    @EventHandler
    public void onMythicMobsMechanicsLoad(MythicMechanicLoadEvent e) {
        String m;
        switch (m = e.getMechanicName().toLowerCase()) {
            case "asinit": {
                ArmorStandInitMechanic skill = new ArmorStandInitMechanic((SkillMechanic)e.getContainer(), e.getConfig());
                e.register((ISkillMechanic)skill);
                break;
            }
            case "asunload": {
                ArmorStandUnloadMechanic skill = new ArmorStandUnloadMechanic((SkillMechanic)e.getContainer(), e.getConfig());
                e.register((ISkillMechanic)skill);
                break;
            }
            case "aspause": {
                ArmorStandPauseMechanic skill = new ArmorStandPauseMechanic((SkillMechanic)e.getContainer(), e.getConfig());
                e.register((ISkillMechanic)skill);
                break;
            }
            case "asrun": {
                ArmorStandRunMechanic skill = new ArmorStandRunMechanic((SkillMechanic)e.getContainer(), e.getConfig());
                e.register((ISkillMechanic)skill);
                break;
            }
            case "aschange": {
                ArmorStandChangeAnimMechanic skill = new ArmorStandChangeAnimMechanic((SkillMechanic)e.getContainer(), e.getConfig());
                e.register((ISkillMechanic)skill);
                break;
            }
            case "aslookat": {
                ArmorStandLookAtMechanic skill = new ArmorStandLookAtMechanic((SkillMechanic)e.getContainer(), e.getConfig());
                e.register((ISkillMechanic)skill);
                break;
            }
        }
    }

    @EventHandler
    public void onMythicMobsConditionsLoad(MythicConditionLoadEvent e) {
        String c;
        switch (c = e.getConditionName().toLowerCase()) {
            case "animatestandpaused": {
                ArmorStandPauseCondition condition = new ArmorStandPauseCondition(c, e.getConfig());
                e.register((ISkillCondition)condition);
                break;
            }
            case "isanimatestand": {
                ArmorStandIsAnimator condition = new ArmorStandIsAnimator(c, e.getConfig());
                e.register((ISkillCondition)condition);
                break;
            }
            case "aimobtargetdistance": {
                ArmorStandaiMobTargetDistance condition = new ArmorStandaiMobTargetDistance(c, e.getConfig());
                e.register((ISkillCondition)condition);
                break;
            }
        }
    }

    @EventHandler
    public void onMythicMobTargeterLoad(MythicTargeterLoadEvent e) {
        if (e.getTargeterName().toLowerCase().equals("aitarget")) {
            e.register((ISkillTargeter)new AiMobTargeter(e.getConfig()));
        }
    }

    @EventHandler
    public void onAiMobDeath(MythicMobDeathEvent e) {
        if (!e.getEntity().hasMetadata("aiMob")) {
            return;
        }
        UUID u = this.getUUIDbyMeta(e.getEntity());
        ActiveMob am = (ActiveMob)MythicBukkit.inst().getMobManager().getActiveMob(u).get();
        am.setDead();
        am.signalMob(BukkitAdapter.adapt((Entity)e.getKiller()), "DEATH");
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onAiMobDamage(EntityDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent ed = (EntityDamageByEntityEvent)e;
            UUID u = null;
            if (ed.getDamager().hasMetadata("aiMob")) {
                ed.setCancelled(true);
                u = this.getUUIDbyMeta(ed.getDamager());
                if (MythicBukkit.inst().getMobManager().isActiveMob(u)) {
                    ActiveMob am = (ActiveMob)MythicBukkit.inst().getMobManager().getActiveMob(u).get();
                    am.setTarget(BukkitAdapter.adapt((Entity)e.getEntity()));
                    new AbstractTriggeredSkill(SkillTriggers.ATTACK, am, BukkitAdapter.adapt((Entity)e.getEntity()));
                }
                return;
            }
            if (e.getEntity().hasMetadata("aiMob")) {
                u = this.getUUIDbyMeta(e.getEntity());
                if (MythicBukkit.inst().getMobManager().isActiveMob(u)) {
                    ActiveMob am = (ActiveMob)MythicBukkit.inst().getMobManager().getActiveMob(u).get();
                    AbstractEntity damager = this.getAttacker(ed.getDamager());
                    am.setLastAggroCause(damager);
                    new AbstractTriggeredSkill(SkillTriggers.DAMAGED, am, damager);
                }
                return;
            }
        } else if (e.getEntity().hasMetadata("aiMob")) {
            UUID u = this.getUUIDbyMeta(e.getEntity());
            if (MythicBukkit.inst().getMobManager().isActiveMob(u)) {
                ActiveMob am = (ActiveMob)MythicBukkit.inst().getMobManager().getActiveMob(u).get();
                new AbstractTriggeredSkill(SkillTriggers.DAMAGED, am, null);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onAnimatorStandHandleDamage(EntityDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.getEntity().getType().equals((Object)EntityType.ARMOR_STAND) && e.getEntity().hasMetadata("asa")) {
            EntityDamageByEntityEvent ee;
            AbstractEntity attacker;
            ArmorStandAnimator asa = ArmorStandUtils.getAnimatorInstance(BukkitAdapter.adapt((Entity)e.getEntity()));
            if (!asa.hasAI()) {
                return;
            }
            e.setCancelled(true);
            if (e instanceof EntityDamageByEntityEvent && !asa.isDying && !(attacker = this.getAttacker((ee = (EntityDamageByEntityEvent)e).getDamager())).isPlayer()) {
                LivingEntity entity = (LivingEntity)asa.aiMob.getEntity().getBukkitEntity();
                entity.damage(e.getDamage(), ee.getDamager());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInteractTrigger(PlayerInteractAtEntityEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (ArmorStandUtils.isArmorStandAnimation(e.getRightClicked())) {
            e.setCancelled(true);
        }
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Entity l = e.getRightClicked();
        if (l.hasMetadata("aiMob")) {
            ActiveMob am;
            AbstractTriggeredSkill ts;
            UUID u = this.getUUIDbyMeta(l);
            if (MythicBukkit.inst().getMobManager().isActiveMob(u) && (ts = new AbstractTriggeredSkill(SkillTriggers.INTERACT, am = (ActiveMob)MythicBukkit.inst().getMobManager().getActiveMob(u).get(), (AbstractEntity)BukkitAdapter.adapt((Player)e.getPlayer()), null, true)).getCancelled()) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onAiMobDeathEvent(MythicMobDeathEvent e) {
        if (e.getEntity().hasMetadata("aiMob")) {
            UUID u = this.getUUIDbyMeta(e.getEntity());
            if (MythicBukkit.inst().getMobManager().isActiveMob(u)) {
                ActiveMob am = (ActiveMob)MythicBukkit.inst().getMobManager().getActiveMob(u).get();
                AbstractEntity killer = BukkitAdapter.adapt((Entity)e.getKiller());
                am.setLastAggroCause(killer);
                new AbstractTriggeredSkill(SkillTriggers.DEATH, am, killer);
                final ArmorStandAnimator asa = ArmorStandUtils.getAnimatorInstance(am.getEntity());
                asa.isDying = true;
                new BukkitRunnable(){

                    public void run() {
                        if (asa != null) {
                            asa.getArmorStand().remove();
                            asa.stop();
                            asa.remove();
                        }
                    }
                }.runTaskLater(AnimatorStands.inst(), 20L);
            }
        }
    }

    private AbstractEntity getAttacker(Entity damager) {
        if (damager instanceof Projectile) {
            if (((Projectile)damager).getShooter() instanceof LivingEntity) {
                LivingEntity shooter = (LivingEntity)((Projectile)damager).getShooter();
                if (shooter != null && shooter instanceof LivingEntity) {
                    return BukkitAdapter.adapt((Entity)shooter);
                }
            } else {
                return null;
            }
        }
        if (damager instanceof LivingEntity) {
            return BukkitAdapter.adapt((Entity)damager);
        }
        return null;
    }

    private UUID getUUIDbyMeta(Entity e) {
        return UUID.fromString(((MetadataValue)e.getMetadata("aiMob").get(0)).asString());
    }
}

