/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.animatorstands;

import com.gmail.berndivader.animatorstands.AnimatorStands;
import com.gmail.berndivader.animatorstands.ArmorStandAnimator;
import org.bukkit.scheduler.BukkitRunnable;

public class AnimatorClock {
    public AnimatorClock() {
        new BukkitRunnable(){
            private long cleanUpTick = 600L;
            private long currentCleanUpTick = 0L;
            private long aiClock = 0L;
            private long currentAiTick = 0L;

            public void run() {
                ++this.currentCleanUpTick;
                ++this.currentAiTick;
                ArmorStandAnimator.animators.values().stream().forEach(animator -> {
                    ++animator.currentAnimTick;
                    if (animator.currentAnimTick >= animator.AnimClock) {
                        animator.update();
                        animator.currentAnimTick = 0;
                    }
                    if (animator.hasAI() && this.currentAiTick >= this.aiClock) {
                        ArmorStandAnimator.doAI(animator);
                    }
                });
                if (this.currentAiTick >= this.aiClock) {
                    this.currentAiTick = 0L;
                }
                if (this.currentCleanUpTick >= this.cleanUpTick) {
                    this.currentCleanUpTick = 0L;
                    ArmorStandAnimator.animators.values().removeIf(e -> {
                        if (e.getArmorStand() == null || e.getArmorStand().isDead()) {
                            if (e.hasAI()) {
                                e.aiMob.setDead();
                            }
                            return true;
                        }
                        return false;
                    });
                }
            }
        }.runTaskTimer(AnimatorStands.inst(), 0L, 0L);
    }
}

