/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicdenizenaddon.cmds;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.gmail.berndivader.mythicdenizenaddon.MythicMobsAddon;
import com.gmail.berndivader.mythicdenizenaddon.obj.dActiveMob;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MobManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class MythicMobsSpawn
extends AbstractCommand {
    static MobManager mobmanager = MythicMobsAddon.mythicmobs.getMobManager();

    public void parseArgs(ScriptEntry entry) throws InvalidArgumentsException {
        for (Argument arg : entry.getProcessedArgs()) {
            if (!entry.hasObject("mobtype") && arg.matchesPrefix("mobtype")) {
                entry.addObject("mobtype", (Object)arg.asElement());
                continue;
            }
            if (!entry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                entry.addObject("location", (Object)arg.asType(LocationTag.class));
                continue;
            }
            if (!entry.hasObject("level") && arg.matchesPrefix("level") && arg.matchesInteger()) {
                entry.addObject("level", (Object)arg.asElement());
                continue;
            }
            if (!entry.hasObject("world") && arg.matchesPrefix("world")) {
                entry.addObject("world", (Object)arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!entry.hasObject("mobtype") || !entry.hasObject("location")) {
            throw new InvalidArgumentsException("mobtype & location is required!");
        }
        if (!entry.hasObject("level")) {
            entry.addObject("level", (Object)new ElementTag(1));
        }
    }

    public void execute(ScriptEntry entry) {
        String mobtype = entry.getElement("mobtype").asString();
        if (mobmanager.getMythicMob(mobtype) == null) {
            System.err.println("No MythicMobType found!");
        }
        int level = entry.getElement("level").asInt();
        LocationTag loc = (LocationTag)entry.getObjectTag("location");
        String worldName = entry.hasObject("world") ? entry.getElement("world").asString() : loc.getWorld().getName();
        AbstractLocation location = BukkitAdapter.adapt((Location)loc);
        AbstractWorld world = BukkitAdapter.adapt((World)Bukkit.getServer().getWorld(worldName));
        if (location == null || world == null) {
            return;
        }
        AbstractLocation sl = new AbstractLocation(world, location.getX(), location.getY(), location.getZ());
        ActiveMob am = mobmanager.spawnMob(mobtype, sl, (double)level);
        if (am != null) {
            entry.addObject("activemob", (Object)new dActiveMob(am));
        }
    }
}

