/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicdenizenaddon.cmds;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.gmail.berndivader.mythicdenizenaddon.MythicDenizenPlugin;
import com.gmail.berndivader.mythicdenizenaddon.obj.ActivePlayer;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import java.util.HashSet;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerSkillCast
extends AbstractCommand {
    private boolean bool;

    public void parseArgs(ScriptEntry entry) throws InvalidArgumentsException {
        for (Argument arg : entry.getProcessedArgs()) {
            if (!entry.hasObject("caster") && arg.matchesPrefix("caster") && arg.matchesArgumentType(EntityTag.class)) {
                entry.addObject("caster", (Object)arg.asType(EntityTag.class));
                continue;
            }
            if (!entry.hasObject("skill") && arg.matchesPrefix("skill")) {
                entry.addObject("skill", (Object)arg.asElement());
                continue;
            }
            if (!entry.hasObject("target") && arg.matchesPrefix("target")) {
                this.bool = !arg.getValue().toLowerCase().startsWith("l@");
                entry.addObject("target", (Object)(this.bool ? arg.asType(EntityTag.class) : arg.asType(LocationTag.class)));
                continue;
            }
            if (!entry.hasObject("trigger") && arg.matchesPrefix("trigger")) {
                entry.addObject("trigger", (Object)arg.asType(EntityTag.class));
                continue;
            }
            if (!entry.hasObject("repeat") && arg.matchesPrefix("repeat") && arg.matchesInteger()) {
                entry.addObject("repeat", (Object)arg.asElement());
                continue;
            }
            if (entry.hasObject("delay") || !arg.matchesPrefix("delay") || !arg.matchesInteger()) continue;
            entry.addObject("delay", (Object)arg.asElement());
        }
        if (!entry.hasObject("trigger")) {
            entry.addObject("trigger", (Object)((EntityTag)entry.getObjectTag("caster")));
        }
        if (!entry.hasObject("repeat")) {
            entry.addObject("repeat", (Object)new ElementTag("0"));
        }
        if (!entry.hasObject("delay")) {
            entry.addObject("delay", (Object)new ElementTag("0"));
        }
    }

    public void execute(ScriptEntry entry) {
        Entity caster = ((EntityTag)entry.getObjectTag("caster")).getBukkitEntity();
        Entity trigger = ((EntityTag)entry.getObjectTag("trigger")).getBukkitEntity();
        int ttimer = entry.getElement("repeat").asInt();
        long tdelay = entry.getElement("delay").asLong();
        Entity etarget = null;
        LocationTag ltarget = null;
        if (this.bool) {
            etarget = ((EntityTag)entry.getObjectTag("target")).getBukkitEntity();
        } else {
            ltarget = (LocationTag)entry.getObjectTag("target");
        }
        String skill = entry.getElement("skill").asString();
        HashSet<AbstractEntity> eTargets = new HashSet<AbstractEntity>();
        HashSet<AbstractLocation> lTargets = new HashSet<AbstractLocation>();
        if (etarget != null) {
            eTargets.add(BukkitAdapter.adapt((Entity)etarget));
        }
        if (ltarget != null) {
            lTargets.add(BukkitAdapter.adapt((Location)ltarget));
        }
        PlayerSkillCast.castSkillFromPlayer(caster, skill, trigger, caster.getLocation(), eTargets, lTargets, 1.0f, ttimer, tdelay);
    }

    private static boolean castSkillFromPlayer(Entity e, String skillName, Entity trigger, Location origin, HashSet<AbstractEntity> feTargets, HashSet<AbstractLocation> flTargets, float power, final int ttimer, long tdelay) {
        SkillMetadata data;
        Optional maybeSkill = MythicMobs.inst().getSkillManager().getSkill(skillName);
        if (!maybeSkill.isPresent()) {
            return false;
        }
        ActivePlayer ap = new ActivePlayer(e);
        final Skill skill = (Skill)maybeSkill.get();
        if (skill.usable(data = new SkillMetadata(SkillTrigger.API, (SkillCaster)ap, BukkitAdapter.adapt((Entity)trigger), BukkitAdapter.adapt((Location)origin), feTargets, flTargets, power), SkillTrigger.API)) {
            new BukkitRunnable(){
                int timer;
                {
                    this.timer = ttimer;
                }

                public void run() {
                    if (this.timer != -1) {
                        skill.execute(data);
                        --this.timer;
                    } else {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)MythicDenizenPlugin.inst(), 0L, tdelay);
        }
        return true;
    }
}

