/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicdenizenaddon.cmds;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.gmail.berndivader.mythicdenizenaddon.MythicMobsAddon;
import com.gmail.berndivader.mythicdenizenaddon.obj.dActiveMob;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.plugin.Plugin;

public class TransformToMythicMob
extends AbstractCommand {
    public void parseArgs(ScriptEntry entry) throws InvalidArgumentsException {
        for (Argument arg : entry.getProcessedArgs()) {
            if (!entry.hasObject("entity") && arg.matchesPrefix("entity") && arg.matchesArgumentType(EntityTag.class)) {
                entry.addObject("entity", (Object)arg.asType(EntityTag.class));
                continue;
            }
            if (!entry.hasObject("mobtype") && arg.matchesPrefix("mobtype")) {
                entry.addObject("mobtype", (Object)arg.asElement());
                continue;
            }
            if (entry.hasObject("level") || !arg.matchesPrefix("level")) continue;
            entry.addObject("level", (Object)arg.asElement());
        }
        if (!entry.hasObject("level")) {
            entry.addObject("level", (Object)1);
        }
    }

    public void execute(ScriptEntry entry) {
        Entity entity = ((EntityTag)entry.getObjectTag("entity")).getBukkitEntity();
        String mmName = entry.getElement("mobtype").asString();
        MythicMob mm = MythicMobsAddon.mythicmobs.getMobManager().getMythicMob(mmName);
        int level = entry.getElement("level").asInt();
        ActiveMob am = null;
        if (mm != null) {
            am = TransformToMythicMob.transformEntityToMythicMob(entity, mm, level);
        }
        if (am != null) {
            entry.addObject("activemob", (Object)new dActiveMob(am));
        }
    }

    private static ActiveMob transformEntityToMythicMob(Entity l, MythicMob mm, int level) {
        ActiveMob am = new ActiveMob(l.getUniqueId(), BukkitAdapter.adapt((Entity)l), mm, (double)level);
        TransformToMythicMob.addActiveMobToFaction(mm, am);
        TransformToMythicMob.registerActiveMob(am);
        return am;
    }

    public static void addActiveMobToFaction(MythicMob mm, ActiveMob am) {
        if (mm.hasFaction()) {
            am.setFaction(mm.getFaction());
            am.getEntity().setMetadata("Faction", (Object)new FixedMetadataValue((Plugin)MythicMobsAddon.mythicmobs, (Object)mm.getFaction()));
        }
    }

    public static void registerActiveMob(ActiveMob am) {
        MythicMobsAddon.mythicmobs.getMobManager().registerActiveMob(am);
    }
}

