/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicdenizenaddon.obj.scoreboards;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.gmail.berndivader.mythicdenizenaddon.ScoreBoardsAddon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;

public class dTeam
implements ObjectTag,
Adjustable {
    private static String id = "team@";
    private String prefix = id;
    private Team team;

    public dTeam(Team scoreboardTeam) {
        if (scoreboardTeam == null) {
            return;
        }
        this.team = scoreboardTeam;
    }

    public static boolean matches(String string) {
        return dTeam.valueOf(string) != null;
    }

    public static dTeam valueOf(String name) {
        return dTeam.valueOf(name, null);
    }

    public void adjust(Mechanism m) {
        ElementTag val = m.getValue();
        switch (m.getName().toLowerCase()) {
            case "addmember": {
                if (!m.requireObject(EntityTag.class)) break;
                Entity entity = ((EntityTag)val.asType(EntityTag.class, m.context)).getBukkitEntity();
                this.team.addEntry(entity instanceof Player ? entity.getName() : entity.getUniqueId().toString());
                break;
            }
            case "delmember": {
                String s1 = val.asString();
                if (!this.team.hasEntry(s1)) break;
                this.team.removeEntry(s1);
                break;
            }
            case "displayname": {
                this.team.setDisplayName(val.asString());
                break;
            }
            case "collision": {
                try {
                    this.team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.valueOf((String)val.asString().toUpperCase()));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                break;
            }
            case "deathmessage": {
                try {
                    this.team.setOption(Team.Option.DEATH_MESSAGE_VISIBILITY, Team.OptionStatus.valueOf((String)val.asString().toUpperCase()));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                break;
            }
            case "nametag": {
                try {
                    this.team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.valueOf((String)val.asString().toUpperCase()));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                break;
            }
            case "friendlyfire": {
                this.team.setCanSeeFriendlyInvisibles(val.asBoolean());
                break;
            }
            case "prefix": {
                this.team.setPrefix(val.asString());
                break;
            }
            case "suffix": {
                this.team.setSuffix(val.asString());
            }
        }
    }

    public String getAttribute(Attribute a) {
        if (a == null) {
            return null;
        }
        if (a.startsWith("name")) {
            return new ElementTag(this.team.getName()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("displayname")) {
            return new ElementTag(this.team.getDisplayName()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("members")) {
            return ScoreBoardsAddon.getAllMembersOfTeam(this.team).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("collision")) {
            Team.OptionStatus oStat = this.team.getOption(Team.Option.COLLISION_RULE);
            return new ElementTag(oStat.toString()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("deathmessage")) {
            Team.OptionStatus oStat = this.team.getOption(Team.Option.DEATH_MESSAGE_VISIBILITY);
            return new ElementTag(oStat.toString()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("nametag")) {
            Team.OptionStatus oStat = this.team.getOption(Team.Option.NAME_TAG_VISIBILITY);
            return new ElementTag(oStat.toString()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("friendlyfire")) {
            return new ElementTag(this.team.allowFriendlyFire()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("friendlyinvisibles")) {
            return new ElementTag(this.team.canSeeFriendlyInvisibles()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("prefix")) {
            return new ElementTag(this.team.getPrefix()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("suffix")) {
            return new ElementTag(this.team.getSuffix()).getAttribute(a.fulfill(1));
        }
        return new ElementTag(this.identify()).getAttribute(a);
    }

    public void applyProperty(Mechanism mech) {
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'";
    }

    public String getObjectType() {
        return "ScoreboardTeam";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String identify() {
        return this.team != null ? this.team.getName() : null;
    }

    public String identifySimple() {
        return this.identify();
    }

    public boolean isUnique() {
        return true;
    }

    public ObjectTag setPrefix(String string) {
        this.prefix = string;
        return this;
    }

    @Fetchable(value="team")
    public static dTeam valueOf(String string, TagContext context) {
        if (string != null) {
            return new dTeam(ScoreBoardsAddon.scoreboard.getTeam(string.replace(id, "")));
        }
        return null;
    }
}

