/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicdenizenaddon.obj;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.gmail.berndivader.mythicdenizenaddon.MythicMobsAddon;
import com.gmail.berndivader.mythicdenizenaddon.obj.dMythicSpawner;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import java.util.UUID;
import org.bukkit.entity.Entity;

public class dActiveMob
implements ObjectTag,
Adjustable {
    static String id = "activemob@";
    private String prefix;
    private ActiveMob am;
    private Entity entity;

    public static boolean matches(String string) {
        return dActiveMob.valueOf(string) != null;
    }

    public static dActiveMob valueOf(String uuid) {
        return dActiveMob.valueOf(uuid, null);
    }

    public dActiveMob(ActiveMob activeMob) {
        if (activeMob == null) {
            return;
        }
        this.am = activeMob;
        this.entity = BukkitAdapter.adapt((AbstractEntity)activeMob.getEntity());
    }

    public ActiveMob getActiveMob() {
        return this.am;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void adjust(Mechanism m) {
        ElementTag val = m.getValue();
        switch (m.getName().toLowerCase()) {
            case "gcd": {
                this.am.setGlobalCooldown(val.asInt());
                break;
            }
            case "remove": {
                MythicMobsAddon.removeSelf(this.am);
                break;
            }
            case "displayname": {
                MythicMobsAddon.setCustomName(this.am, val.asString());
                break;
            }
            case "owner": {
                this.am.setOwner(((EntityTag)val.asType(EntityTag.class, m.context)).getUUID());
                break;
            }
            case "target": {
                MythicMobsAddon.setTarget(this.am, ((EntityTag)val.asType(EntityTag.class, m.context)).getBukkitEntity());
                break;
            }
            case "faction": {
                this.am.setFaction(val.asString());
                break;
            }
            case "stance": {
                this.am.setStance(val.asString());
                break;
            }
            case "level": {
                this.am.setLevel((double)val.asInt());
                break;
            }
            case "playerkills": {
                this.am.importPlayerKills(val.asInt());
                break;
            }
            case "health": {
                this.am.getEntity().setHealth(val.asDouble());
                break;
            }
            case "maxhealth": {
                this.am.getEntity().setMaxHealth(val.asDouble());
                break;
            }
            case "incthreat": 
            case "decthreat": {
                String[] parse = val.asString().split("\\|");
                if (parse.length <= 1) break;
                ElementTag entity = new ElementTag(parse[0]);
                ElementTag value = new ElementTag(parse[1]);
                if (!entity.matchesType(EntityTag.class) || !value.isDouble()) break;
                MythicMobsAddon.modThreatOfEntity(this.am, (EntityTag)entity.asType(EntityTag.class, m.context), value.asDouble(), m.getName());
                break;
            }
            case "clearthreat": 
            case "zapthreat": {
                this.am.getThreatTable().getAllThreatTargets().clear();
                break;
            }
            case "removethreat": 
            case "delththreat": {
                if (!val.matchesType(EntityTag.class)) break;
                MythicMobsAddon.removeThreatOfEntity(this.am, (EntityTag)val.asType(EntityTag.class, m.context));
                break;
            }
            case "newtargetthreattable": {
                this.am.getThreatTable().clearTarget();
                this.am.getThreatTable().dropCombat();
                this.am.getThreatTable().targetHighestThreat();
                break;
            }
            case "getnewtarget": {
                this.am.getNewTarget();
                break;
            }
            case "setimmunitycooldown": {
                if (!m.requireObject(EntityTag.class)) break;
                this.am.getImmunityTable().setCooldown(BukkitAdapter.adapt((Entity)((EntityTag)val.asType(EntityTag.class, m.context)).getBukkitEntity()));
            }
        }
    }

    public String getAttribute(Attribute a) {
        if (a == null) {
            return null;
        }
        if (a.startsWith("isdead")) {
            return new ElementTag(MythicMobsAddon.isDead(this.entity)).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("entity")) {
            return new EntityTag(this.am.getEntity().getBukkitEntity()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("hasthreattable")) {
            return new ElementTag(MythicMobsAddon.hasThreatTable(this.entity)).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("threattable")) {
            return MythicMobsAddon.getThreatTable(this.am).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("threatvalueof") && a.hasContext(1)) {
            return new ElementTag(MythicMobsAddon.getThreatValueOf(this.am, EntityTag.valueOf((String)a.getContext(1)))).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("hastarget")) {
            return new ElementTag(MythicMobsAddon.hasTarget(this.am)).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("hasmythicspawner")) {
            return new ElementTag(MythicMobsAddon.hasMythicSpawner(this.entity)).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("mythicspawner")) {
            return new dMythicSpawner(this.am.getSpawner()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("mobtype")) {
            return new ElementTag(this.am.getType().getInternalName()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("displayname")) {
            return new ElementTag(this.am.getType().getDisplayName().get()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("location")) {
            return new LocationTag(BukkitAdapter.adapt((AbstractLocation)this.am.getLocation())).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("world")) {
            return new WorldTag(BukkitAdapter.adapt((AbstractWorld)this.am.getLocation().getWorld())).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("owner")) {
            return new EntityTag(MythicMobsAddon.getOwner(this.am)).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("lastaggro")) {
            return new EntityTag(MythicMobsAddon.getLastAggro(this.am)).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("toptarget")) {
            return new EntityTag(MythicMobsAddon.getTopTarget(this.am)).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("uuid")) {
            return new ElementTag(this.am.getUniqueId().toString()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("health")) {
            return new ElementTag(this.am.getEntity().getHealth()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("maxhealth")) {
            return new ElementTag(this.am.getEntity().getMaxHealth()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("faction")) {
            return new ElementTag(this.am.getFaction()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("stance")) {
            return new ElementTag(this.am.getStance()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("level")) {
            return new ElementTag(this.am.getLevel()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("playerkills")) {
            return new ElementTag(this.am.getPlayerKills()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("lastsignal")) {
            return new ElementTag(this.am.getLastSignal()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("type")) {
            return new ElementTag("ActiveMob").getAttribute(a.fulfill(1));
        }
        if (a.startsWith("damage")) {
            return new ElementTag(this.am.getDamage()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("power")) {
            return new ElementTag(this.am.getPower()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("lastdamageskillamount")) {
            return new ElementTag(this.am.getLastDamageSkillAmount()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("hasimmunitytable")) {
            return new ElementTag(this.am.hasImmunityTable()).getAttribute(a.fulfill(1));
        }
        if (a.startsWith("isonimmunitycooldown") && a.hasContext(1)) {
            AbstractEntity ae = BukkitAdapter.adapt((Entity)EntityTag.valueOf((String)a.getContext(1)).getBukkitEntity());
            return new ElementTag(this.am.getImmunityTable().onCooldown(ae)).getAttribute(a.fulfill(1));
        }
        return new ElementTag(this.identify()).getAttribute(a);
    }

    public void applyProperty(Mechanism mech) {
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'";
    }

    public String getObjectType() {
        return "ActiveMob";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String identify() {
        return this.am != null ? id + this.am.getUniqueId() : null;
    }

    public String identifySimple() {
        return this.identify();
    }

    public boolean isUnique() {
        return true;
    }

    public ObjectTag setPrefix(String string) {
        this.prefix = string;
        return this;
    }

    public String toString() {
        return this.identify();
    }

    @Fetchable(value="activemob")
    public static dActiveMob valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        try {
            string = string.replace(id, "");
            UUID uuid = UUID.fromString(string);
            if (!MythicMobsAddon.isActiveMob(uuid)) {
                return null;
            }
            return new dActiveMob(MythicMobsAddon.getActiveMob(EntityTag.getEntityForID((UUID)uuid)));
        }
        catch (Exception e) {
            return null;
        }
    }
}

