/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.compatibility.worldguard;

import com.gmail.berndivader.mythicmobsext.compatibility.worldguard.Reflections;
import com.gmail.berndivader.mythicmobsext.compatibility.worldguard.WorldGuardUtils;
import com.gmail.berndivader.mythicmobsext.conditions.AbstractCustomCondition;
import com.gmail.berndivader.mythicmobsext.utils.RangedDouble;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import com.gmail.berndivader.mythicmobsext.utils.Vec3D;
import com.gmail.berndivader.mythicmobsext.volatilecode.Volatile;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.World;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;

public class EntitiesInRegionCondition
extends AbstractCustomCondition
implements ILocationCondition {
    List<String> region_names;
    List<String> region_names_exclude;
    String[] types;
    boolean debug;
    boolean use_priority;
    boolean all_types;
    boolean all_regions;
    Predicate<Entity> entities;
    RangedDouble amount;

    public EntitiesInRegionCondition(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.amount = new RangedDouble(mlc.getString("amount", ">0"));
        this.region_names = Arrays.asList(mlc.getString(new String[]{"regions", "region", "r"}, new String(), new String[0]).toUpperCase().split(","));
        this.region_names_exclude = Arrays.asList(("__global__," + mlc.getString("exclude", new String())).toUpperCase().split(","));
        this.types = mlc.getString("types", "ANY").toUpperCase().split(",");
        this.all_types = this.types[0].equals("ANY");
        this.all_regions = this.region_names.contains("ANY");
        this.use_priority = mlc.getBoolean("usepriority", false);
        this.entities = entity -> {
            if (this.all_types) {
                return true;
            }
            for (String type : this.types) {
                if (type.startsWith("MYTHICMOB")) {
                    String[] temp = type.split(":");
                    if (temp.length <= 1) continue;
                    String mythicmob_type = temp[1];
                    if (mythicmob_type.equals("ANY") && Utils.mobmanager.isActiveMob(entity.getUniqueId())) {
                        return true;
                    }
                    ActiveMob am = Utils.mobmanager.getMythicMobInstance(entity);
                    if (am == null || !am.getType().getInternalName().toUpperCase().equals(mythicmob_type)) continue;
                    return true;
                }
                switch (type) {
                    case "ENTITY": {
                        return entity instanceof Entity;
                    }
                    case "LIVING": {
                        return entity instanceof LivingEntity;
                    }
                    case "PLAYER": {
                        return entity instanceof Player;
                    }
                    case "ANIMAL": {
                        return entity instanceof Animals;
                    }
                    case "MONSTER": {
                        return entity instanceof Monster;
                    }
                    case "CREATURE": {
                        return entity instanceof Creature;
                    }
                }
                if (!entity.getClass().getSimpleName().toUpperCase().contains(type)) continue;
                return true;
            }
            return false;
        };
    }

    public boolean check(AbstractLocation al) {
        Set<ProtectedRegion> regions_set = WorldGuardUtils.getRegionsByLocation(BukkitAdapter.adapt((AbstractLocation)al));
        int size = 0;
        if (regions_set != null) {
            World world = BukkitAdapter.adapt((AbstractLocation)al).getWorld();
            List<Object> regions = regions_set.stream().filter(r -> !this.region_names_exclude.contains(r.getId().toUpperCase())).collect(Collectors.toList());
            if (this.use_priority) {
                Optional<ProtectedRegion> maybe = regions.stream().max(Comparator.comparing(ProtectedRegion::getPriority));
                if (maybe.isPresent()) {
                    ProtectedRegion region = maybe.get();
                    if (this.all_regions || this.region_names.contains(region.getId().toUpperCase())) {
                        size += this.sumEntityInRegion(world, region);
                    }
                }
            } else {
                if (!this.all_regions) {
                    regions = regions.stream().filter(r -> this.region_names.contains(r.getId().toUpperCase())).collect(Collectors.toList());
                }
                size += this.sumEntityInRegions(world, regions);
            }
        }
        return this.amount.equals(size);
    }

    int sumEntityInRegion(World world, ProtectedRegion region) {
        Vec3D min_point = Reflections.getMinimumPoint(region);
        Vec3D max_point = Reflections.getMaximumPoint(region);
        BoundingBox box = new BoundingBox(min_point.getX(), min_point.getY(), min_point.getZ(), max_point.getX(), max_point.getY(), max_point.getZ());
        return Volatile.handler.getNearbyEntities(world, box, this.entities).size();
    }

    int sumEntityInRegions(World world, List<ProtectedRegion> regions) {
        if (regions.isEmpty()) {
            return 0;
        }
        ProtectedRegion first_region = regions.get(0);
        Vec3D min_point = Reflections.getMinimumPoint(first_region);
        Vec3D max_point = Reflections.getMaximumPoint(first_region);
        double min_x = min_point.getX();
        double min_y = min_point.getY();
        double min_z = min_point.getZ();
        double max_x = max_point.getX();
        double max_y = max_point.getY();
        double max_z = max_point.getZ();
        int size = regions.size();
        for (int i1 = 1; i1 < size; ++i1) {
            ProtectedRegion region = regions.get(i1);
            min_point = Reflections.getMinimumPoint(region);
            max_point = Reflections.getMaximumPoint(region);
            if (min_point.getX() < min_x) {
                min_x = min_point.getX();
            }
            if (min_point.getY() < min_y) {
                min_y = min_point.getY();
            }
            if (min_point.getZ() < min_z) {
                min_z = min_point.getZ();
            }
            if (max_point.getX() > max_x) {
                max_x = max_point.getX();
            }
            if (max_point.getY() > max_y) {
                max_y = max_point.getY();
            }
            if (!(max_point.getZ() > max_z)) continue;
            max_z = max_point.getZ();
        }
        BoundingBox box = new BoundingBox(min_x, min_y, min_z, max_x, max_y, max_z);
        return Volatile.handler.getNearbyEntities(world, box, this.entities).size();
    }
}

