/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@ExternalAnnotation(name="breakblock_ext", author="BerndiVader")
public class BreakBlock
extends SkillMechanic
implements ITargetedLocationSkill {
    int restore;
    BlockFace block_face;
    boolean play_effect;

    public BreakBlock(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.restore = mlc.getInteger("restore", 0);
        this.play_effect = mlc.getBoolean("effect", false);
        try {
            this.block_face = BlockFace.valueOf((String)mlc.getString("blockface", "down").toUpperCase());
        }
        catch (Exception e) {
            this.block_face = BlockFace.DOWN;
        }
    }

    public boolean castAtLocation(SkillMetadata data, AbstractLocation al) {
        Block block = BukkitAdapter.adapt((AbstractLocation)al).getBlock().getRelative(this.block_face);
        if (block.getType() != Material.AIR) {
            final BlockState block_state = block.getState();
            block.breakNaturally();
            if (this.restore > 0) {
                new BukkitRunnable(){

                    public void run() {
                        block_state.getBlock().setType(block_state.getType());
                        block_state.update();
                        block_state.getWorld().playEffect(block_state.getLocation(), Effect.STEP_SOUND, (Object)block_state.getType());
                    }
                }.runTaskLater((Plugin)Main.getPlugin(), (long)this.restore);
            }
            return true;
        }
        return false;
    }
}

