/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.jboolexpr.BooleanExpression;
import com.gmail.berndivader.mythicmobsext.jboolexpr.MalformedBooleanException;
import com.gmail.berndivader.mythicmobsext.targeters.CustomTargeters;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.skills.SkillTargeter;
import io.lumine.xikage.mythicmobs.skills.conditions.InvalidCondition;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.skills.targeters.CustomTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.IEntitySelector;
import io.lumine.xikage.mythicmobs.skills.targeters.ILocationSelector;
import io.lumine.xikage.mythicmobs.skills.targeters.TriggerTargeter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.regex.Pattern;

@ExternalAnnotation(name="castif", author="BerndiVader")
public class CastIfMechanic
extends SkillMechanic
implements INoTargetSkill,
ITargetedEntitySkill,
ITargetedLocationSkill {
    private PlaceholderString meetAction;
    private PlaceholderString elseAction;
    private String cConditionLine;
    private String tConditionLine;
    private boolean breakOnMeet;
    private boolean breakOnElse;
    private boolean RTskill;
    private HashMap<Integer, String> tConditionLines = new HashMap();
    private HashMap<Integer, String> cConditionLines = new HashMap();
    private HashMap<Integer, SkillCondition> targetConditions = new HashMap();
    private HashMap<Integer, SkillCondition> casterConditions = new HashMap();
    private Optional<Skill> meetSkill = Optional.empty();
    private Optional<Skill> elseSkill = Optional.empty();
    private Optional<String> meetTargeter;
    private Optional<String> elseTargeter;

    public CastIfMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        String mt;
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.breakOnMeet = mlc.getBoolean(new String[]{"breakonmeet", "breakmeet"}, false);
        this.breakOnElse = mlc.getBoolean(new String[]{"breakonelse", "breakelse"}, false);
        this.RTskill = mlc.getBoolean(new String[]{"realtime", "rtskill", "rt"}, false);
        String ms = mlc.getString(new String[]{"conditions", "c"});
        this.parseConditionLines(ms, false);
        ms = mlc.getString(new String[]{"targetconditions", "tc"});
        this.parseConditionLines(ms, true);
        this.meetAction = new PlaceholderString(SkillString.parseMessageSpecialChars((String)mlc.getString(new String[]{"meet", "m"})));
        this.elseAction = new PlaceholderString(SkillString.parseMessageSpecialChars((String)mlc.getString(new String[]{"else", "e"})));
        this.meetTargeter = Optional.ofNullable(mlc.getString(new String[]{"meettargeter", "mt"}));
        this.elseTargeter = Optional.ofNullable(mlc.getString(new String[]{"elsetargeter", "et"}));
        if (!this.RTskill) {
            if (this.meetAction != null) {
                this.meetSkill = Utils.mythicmobs.getSkillManager().getSkill(this.meetAction.get());
            }
            if (this.elseAction != null) {
                this.elseSkill = Utils.mythicmobs.getSkillManager().getSkill(this.elseAction.get());
            }
        }
        if (this.cConditionLines != null && !this.cConditionLines.isEmpty()) {
            this.casterConditions = this.getConditions(this.cConditionLines);
        }
        if (this.tConditionLines != null && !this.tConditionLines.isEmpty()) {
            this.targetConditions = this.getConditions(this.tConditionLines);
        }
        if (this.meetTargeter.isPresent()) {
            mt = this.meetTargeter.get();
            mt = mt.substring(1, mt.length() - 1);
            mt = SkillString.parseMessageSpecialChars((String)mt);
            this.meetTargeter = Optional.of(mt);
        }
        if (this.elseTargeter.isPresent()) {
            mt = this.elseTargeter.get();
            mt = mt.substring(1, mt.length() - 1);
            mt = SkillString.parseMessageSpecialChars((String)mt);
            this.elseTargeter = Optional.of(mt);
        }
    }

    public boolean cast(SkillMetadata data) {
        SkillMetadata skillData = data.deepClone();
        Optional<Object> mSkill = Optional.empty();
        Optional<Object> eSkill = Optional.empty();
        if (this.RTskill) {
            AbstractEntity at = null;
            AbstractLocation al = null;
            if (skillData.getEntityTargets() != null && skillData.getEntityTargets().size() > 0) {
                at = (AbstractEntity)skillData.getEntityTargets().iterator().next();
            }
            if (skillData.getLocationTargets() != null && skillData.getLocationTargets().size() > 0) {
                al = (AbstractLocation)skillData.getLocationTargets().iterator().next();
            }
            if (this.meetAction != null) {
                mSkill = Utils.mythicmobs.getSkillManager().getSkill(this.meetAction.get((PlaceholderMeta)data, at));
            }
            if (this.elseAction != null) {
                eSkill = Utils.mythicmobs.getSkillManager().getSkill(this.elseAction.get((PlaceholderMeta)data, at));
            }
        } else {
            mSkill = this.meetSkill;
            eSkill = this.elseSkill;
        }
        if (this.handleConditions(skillData)) {
            if (mSkill.isPresent() && ((Skill)mSkill.get()).isUsable(skillData)) {
                this.meetTargeter.ifPresent(s -> CastIfMechanic.renewTargets(s, skillData));
                ((Skill)mSkill.get()).execute(skillData);
            }
        } else if (eSkill.isPresent() && ((Skill)eSkill.get()).isUsable(skillData)) {
            this.elseTargeter.ifPresent(s -> CastIfMechanic.renewTargets(s, skillData));
            ((Skill)eSkill.get()).execute(skillData);
        }
        return true;
    }

    private static void renewTargets(String ts, SkillMetadata data) {
        Optional<SkillTargeter> maybeTargeter = Optional.of(Utils.parseSkillTargeter(ts));
        if (maybeTargeter.isPresent()) {
            SkillTargeter st = maybeTargeter.get();
            if (st instanceof CustomTargeter) {
                String s1 = ts.substring(1);
                MythicLineConfig mlc = new MythicLineConfig(s1);
                String s2 = s1.contains("{") ? s1.substring(0, s1.indexOf("{")) : s1;
                st = CustomTargeters.getCustomTargeter(s2, mlc);
                if (st == null) {
                    st = new TriggerTargeter(mlc);
                }
            }
            if (st instanceof IEntitySelector) {
                if (data.getEntityTargets() == null) {
                    data.setEntityTargets(new HashSet());
                }
                ((IEntitySelector)st).filter(data, false);
                data.setEntityTargets((Collection)((IEntitySelector)st).getEntities(data));
            } else if (st instanceof ILocationSelector) {
                if (data.getLocationTargets() == null) {
                    data.setLocationTargets(new HashSet());
                }
                ((ILocationSelector)st).filter(data);
                data.setLocationTargets((Collection)((ILocationSelector)st).getLocations(data));
            }
        }
    }

    public boolean castAtLocation(SkillMetadata data, AbstractLocation location) {
        SkillMetadata skillData = data.deepClone();
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        targets.add(location);
        skillData.setLocationTargets(targets);
        return this.cast(skillData);
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity entity) {
        SkillMetadata skillData = data.deepClone();
        HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
        targets.add(entity);
        skillData.setEntityTargets(targets);
        return this.cast(skillData);
    }

    public boolean handleConditions(SkillMetadata data) {
        boolean meet = true;
        if (!this.casterConditions.isEmpty()) {
            meet = this.checkConditions(data, this.casterConditions, false);
        }
        if (!this.targetConditions.isEmpty() && meet) {
            meet = this.checkConditions(data, this.targetConditions, true);
        }
        return meet;
    }

    private boolean checkConditions(SkillMetadata data, HashMap<Integer, SkillCondition> conditions, boolean isTarget) {
        String cline = isTarget ? this.tConditionLine : this.cConditionLine;
        for (int a = 0; a < conditions.size(); ++a) {
            SkillMetadata skillData = data.deepClone();
            SkillCondition condition = conditions.get(a);
            cline = isTarget ? cline.replaceFirst(Pattern.quote(this.tConditionLines.get(a)), Boolean.toString(condition.evaluateTargets(skillData))) : cline.replaceFirst(Pattern.quote(this.cConditionLines.get(a)), Boolean.toString(condition.evaluateCaster(skillData)));
        }
        return this.expressBoolean(cline);
    }

    boolean expressBoolean(String expr) {
        BooleanExpression be;
        try {
            be = BooleanExpression.readLR(expr);
        }
        catch (MalformedBooleanException e) {
            Main.logger.warning("There was a problem parsing BoolExpr: " + this.getConfigLine());
            return false;
        }
        return be.booleanValue();
    }

    private HashMap<Integer, SkillCondition> getConditions(HashMap<Integer, String> conditionList) {
        HashMap<Integer, SkillCondition> conditions = new HashMap<Integer, SkillCondition>();
        for (int a = 0; a < conditionList.size(); ++a) {
            SkillCondition sc;
            String s = conditionList.get(a);
            if (s.startsWith(" ")) {
                s = s.substring(1);
            }
            if ((sc = SkillCondition.getCondition((String)s)) instanceof InvalidCondition) continue;
            conditions.put(a, sc);
        }
        return conditions;
    }

    private void parseConditionLines(String ms, boolean istarget) {
        if (ms != null && ms.startsWith("\"") && ms.endsWith("\"")) {
            ms = ms.substring(1, ms.length() - 1);
            ms = SkillString.parseMessageSpecialChars((String)ms);
            if (istarget) {
                this.tConditionLine = ms;
            } else {
                this.cConditionLine = ms;
            }
            ms = ms.replaceAll("\\(", "").replaceAll("\\)", "");
            String[] parse = ms.split("\\&\\&|\\|\\|");
            if (parse.length > 0) {
                for (int i = 0; i < parse.length; ++i) {
                    String p = parse[i];
                    if (istarget) {
                        this.tConditionLines.put(i, p);
                        continue;
                    }
                    this.cConditionLines.put(i, p);
                }
            }
        }
    }
}

