/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import org.bukkit.Bukkit;
import org.bukkit.WeatherType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@ExternalAnnotation(name="playerweather", author="BerndiVader")
public class PlayerWeatherMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    int duration;
    int time;
    WeatherType type;
    boolean relative;

    public PlayerWeatherMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        try {
            this.type = WeatherType.valueOf((String)mlc.getString(new String[]{"weather", "w"}, "CLEAR", new String[0]).toUpperCase());
        }
        catch (Exception e) {
            this.type = WeatherType.CLEAR;
        }
        this.time = mlc.getInteger(new String[]{"time", "t"}, -1);
        this.duration = mlc.getInteger(new String[]{"duration", "dur"}, 200);
        this.relative = mlc.getBoolean("relative", false);
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isPlayer()) {
            Player p = (Player)target.getBukkitEntity();
            if (this.time > -1) {
                p.setPlayerTime((long)this.time, this.relative);
            }
            p.setPlayerWeather(this.type);
            new WeatherTracker(this.duration, p);
            return true;
        }
        return false;
    }

    private class WeatherTracker
    implements Runnable {
        private Player p;

        public WeatherTracker(int duration, Player player) {
            this.p = player;
            Bukkit.getScheduler().runTaskLater((Plugin)Main.getPlugin(), (Runnable)this, (long)duration);
        }

        @Override
        public void run() {
            this.p.resetPlayerWeather();
            this.p.resetPlayerTime();
        }
    }
}

