/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.MythicPlayers;

import com.gmail.berndivader.MythicPlayers.ActivePlayer;
import com.gmail.berndivader.MythicPlayers.MythicPlayers;
import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.volatilecode.Volatile;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MobManager;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.TriggeredSkill;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerManager
implements Listener {
    public static String meta_MYTHICPLAYER = "MythicPlayer";
    public static String meta_NOACTIVEMOB = "NOACTIVEMOB";
    public static String meta_FACTION = "Faction";
    public static String meta_READYREASON = "READYREASON";
    public static String meta_ITEMCHANGE = "ITEMCHANGE";
    public static String signal_QUIT = "QUIT";
    public static String signal_DEATH = "DEATH";
    private MythicPlayers mythicplayers;
    private MobManager mobmanager = MythicPlayers.mythicmobs.getMobManager();
    private ConcurrentHashMap<UUID, ActivePlayer> activePlayers = new ConcurrentHashMap();

    public PlayerManager(MythicPlayers mythicplayers) {
        this.mythicplayers = mythicplayers;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, mythicplayers.plugin());
    }

    public ActivePlayer registerActiveMob(ActivePlayer ap) {
        this.activePlayers.put(ap.getUniqueId(), ap);
        this.mobmanager.registerActiveMob((ActiveMob)ap);
        return ap;
    }

    public void unregisterActivePlayer(UUID uuid) {
        this.activePlayers.remove(uuid);
        this.mobmanager.unregisterActiveMob(uuid);
    }

    public boolean isActivePlayer(UUID uuid) {
        return this.activePlayers.containsKey(uuid);
    }

    public Optional<ActivePlayer> getActivePlayer(UUID uuid) {
        return Optional.ofNullable(this.activePlayers.getOrDefault(uuid, null));
    }

    public void removeAllEffectsFromPlayer(AbstractEntity e) {
        LivingEntity le = (LivingEntity)e.getBukkitEntity();
        if (e.hasPotionEffect()) {
            Iterator i = le.getActivePotionEffects().iterator();
            while (i.hasNext()) {
                le.removePotionEffect(((PotionEffect)i.next()).getType());
            }
        }
    }

    public void addMythicPlayerToFaction(MythicMob mm, ActivePlayer ap) {
        if (mm.hasFaction()) {
            ap.setFaction(mm.getFaction());
            ap.getEntity().getBukkitEntity().setMetadata(meta_FACTION, (MetadataValue)new FixedMetadataValue((Plugin)MythicPlayers.mythicmobs, (Object)mm.getFaction()));
        }
    }

    public void makeNormalPlayer(ActivePlayer ap) {
        Entity e = ap.getEntity().getBukkitEntity();
        ap.signalMob(ap.getEntity(), meta_NOACTIVEMOB);
        this.removeAllEffectsFromPlayer(ap.getEntity());
        this.removeActivePlayer(ap);
        e.removeMetadata(meta_MYTHICPLAYER, this.mythicplayers.plugin());
        e.removeMetadata(meta_FACTION, this.mythicplayers.plugin());
    }

    public void removeActivePlayer(ActivePlayer ap) {
        Location l = ap.getEntity().getBukkitEntity().getLocation().clone();
        l.setY(0.0);
        AbstractEntity d = BukkitAdapter.adapt((Entity)l.getWorld().spawnEntity(l, EntityType.BAT));
        ap.setEntity(d);
        this.unregisterActivePlayer(ap.getUniqueId());
        d.remove();
    }

    public boolean attachActivePlayer(LivingEntity l, boolean dotrigger) {
        MythicMob mm = this.mobmanager.getMythicMob(((MetadataValue)l.getMetadata(meta_MYTHICPLAYER).get(0)).asString());
        if (mm == null) {
            l.removeMetadata(meta_MYTHICPLAYER, this.mythicplayers.plugin());
            return false;
        }
        ActivePlayer ap = new ActivePlayer(l.getUniqueId(), BukkitAdapter.adapt((Entity)l), mm, 1);
        this.addMythicPlayerToFaction(mm, ap);
        this.registerActiveMob(ap);
        if (dotrigger) {
            new TriggeredSkill(SkillTrigger.SPAWN, (ActiveMob)ap, null, true);
        }
        return true;
    }

    public boolean createActivePlayer(LivingEntity l, MythicMob mm) {
        l.setMetadata(meta_MYTHICPLAYER, (MetadataValue)new FixedMetadataValue(this.mythicplayers.plugin(), (Object)mm.getInternalName()));
        ActivePlayer ap = new ActivePlayer(l.getUniqueId(), BukkitAdapter.adapt((Entity)l), mm, 1);
        this.addMythicPlayerToFaction(mm, ap);
        this.registerActiveMob(ap);
        new TriggeredSkill(SkillTrigger.SPAWN, (ActiveMob)ap, null, true);
        return true;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMythicPlayerDeath(PlayerDeathEvent e) {
        if (!this.isActivePlayer(e.getEntity().getUniqueId())) {
            return;
        }
        ActivePlayer ap = this.getActivePlayer(e.getEntity().getUniqueId()).get();
        ap.signalMob(ap.getEntity(), signal_DEATH);
        this.removeAllEffectsFromPlayer(ap.getEntity());
        this.removeActivePlayer(ap);
    }

    @EventHandler
    public void onMythicPlayerRespawn(final PlayerRespawnEvent e) {
        if (e.getPlayer().hasMetadata(meta_MYTHICPLAYER)) {
            new BukkitRunnable(){

                public void run() {
                    PlayerManager.this.attachActivePlayer((LivingEntity)e.getPlayer(), true);
                }
            }.runTaskLater(this.mythicplayers.plugin(), 1L);
        }
    }

    @EventHandler
    public void onMythicPlayerJoin(PlayerJoinEvent e) {
        if (e.getPlayer().hasMetadata(meta_MYTHICPLAYER)) {
            this.attachActivePlayer((LivingEntity)e.getPlayer(), true);
        }
    }

    @EventHandler
    public void onMythicPlayerQuit(PlayerQuitEvent e) {
        if (this.isActivePlayer(e.getPlayer().getUniqueId())) {
            ActivePlayer ap = this.getActivePlayer(e.getPlayer().getUniqueId()).get();
            this.removeAllEffectsFromPlayer(ap.getEntity());
            ap.signalMob(ap.getEntity(), signal_QUIT);
            this.removeActivePlayer(ap);
        }
    }

    @EventHandler
    public void onMythicPlayerDamage(EntityDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (this.mobmanager == null || this.mobmanager.isActiveMob(e.getEntity().getUniqueId())) {
            return;
        }
        Entity victim = e.getEntity();
        EntityDamageEvent.DamageCause cause = e.getCause();
        victim.setMetadata("LDC", (MetadataValue)new FixedMetadataValue(this.mythicplayers.plugin(), (Object)cause.toString()));
        if (!this.isActivePlayer(victim.getUniqueId())) {
            return;
        }
        if (!(cause.equals((Object)EntityDamageEvent.DamageCause.ENTITY_ATTACK) || cause.equals((Object)EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) || cause.equals((Object)EntityDamageEvent.DamageCause.CUSTOM) || cause.equals((Object)EntityDamageEvent.DamageCause.PROJECTILE))) {
            ActivePlayer ap = this.getActivePlayer(victim.getUniqueId()).get();
            AbstractEntity trigger = null;
            if (e instanceof EntityDamageByEntityEvent) {
                trigger = BukkitAdapter.adapt((Entity)((EntityDamageByEntityEvent)e).getDamager());
            }
            new TriggeredSkill(SkillTrigger.DAMAGED, (ActiveMob)ap, trigger, true);
        }
    }

    @EventHandler
    public void onMythicPlayerToggleSneak(PlayerToggleSneakEvent e) {
        if (e.isCancelled() || !this.isActivePlayer(e.getPlayer().getUniqueId())) {
            return;
        }
        SkillTrigger st = e.getPlayer().isSneaking() ? SkillTrigger.UNCROUCH : SkillTrigger.CROUCH;
        new TriggeredSkill(st, (ActiveMob)this.getActivePlayer(e.getPlayer().getUniqueId()).get(), null, true);
    }

    @EventHandler
    public void onUseTrigger(PlayerInteractEvent e) {
        if (e.getHand() == EquipmentSlot.HAND && this.isActivePlayer(e.getPlayer().getUniqueId())) {
            ActivePlayer ap = this.getActivePlayer(e.getPlayer().getUniqueId()).get();
            TriggeredSkill ts = null;
            switch (e.getAction()) {
                case RIGHT_CLICK_AIR: {
                    ts = new TriggeredSkill(SkillTrigger.RIGHTCLICK, (ActiveMob)ap, ap.getEntity(), true);
                    break;
                }
                case RIGHT_CLICK_BLOCK: {
                    ts = new TriggeredSkill(SkillTrigger.RIGHTCLICK, (SkillCaster)ap, BukkitAdapter.adapt((Location)e.getClickedBlock().getLocation()), ap.getEntity(), new ArrayList(), true);
                    break;
                }
                case LEFT_CLICK_AIR: {
                    ts = e.getPlayer().getInventory().getItemInMainHand() != null ? new TriggeredSkill(SkillTrigger.USE, (ActiveMob)ap, ap.getEntity(), true) : new TriggeredSkill(SkillTrigger.SWING, (ActiveMob)ap, ap.getEntity(), true);
                    break;
                }
                case LEFT_CLICK_BLOCK: {
                    ts = e.getPlayer().getInventory().getItemInMainHand() != null ? new TriggeredSkill(SkillTrigger.USE, (SkillCaster)ap, BukkitAdapter.adapt((Location)e.getClickedBlock().getLocation()), ap.getEntity(), new ArrayList(), true) : new TriggeredSkill(SkillTrigger.SWING, (SkillCaster)ap, BukkitAdapter.adapt((Location)e.getClickedBlock().getLocation()), ap.getEntity(), new ArrayList(), true);
                    break;
                }
            }
            if (ts != null && ts.getCancelled()) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerWorldChangeAtPortal(PlayerPortalEvent e) {
        if (e.isCancelled() || !this.isActivePlayer(e.getPlayer().getUniqueId()) || e.getFrom().getWorld().equals(e.getTo().getWorld())) {
            return;
        }
        Optional<ActivePlayer> maybeActivePlayer = this.getActivePlayer(e.getPlayer().getUniqueId());
        if (maybeActivePlayer.isPresent()) {
            ActivePlayer ap = maybeActivePlayer.get();
            this.removeActivePlayer(ap);
        }
    }

    @EventHandler
    public void onMythicPlayerWorldChangeAtTeleport(PlayerTeleportEvent e) {
        if (e.isCancelled() || !this.isActivePlayer(e.getPlayer().getUniqueId()) || e.getFrom().getWorld().equals(e.getTo().getWorld())) {
            return;
        }
        Optional<ActivePlayer> maybeActivePlayer = this.getActivePlayer(e.getPlayer().getUniqueId());
        if (maybeActivePlayer.isPresent()) {
            ActivePlayer ap = maybeActivePlayer.get();
            this.removeActivePlayer(ap);
        }
    }

    @EventHandler
    public void onMythicPlayerWorldChanged(PlayerChangedWorldEvent e) {
        if (e.getPlayer().hasMetadata(meta_MYTHICPLAYER)) {
            final Player p = e.getPlayer();
            new BukkitRunnable(){

                public void run() {
                    PlayerManager.this.attachActivePlayer((LivingEntity)p, true);
                }
            }.runTaskLater(this.mythicplayers.plugin(), 50L);
        }
    }

    @EventHandler
    public void onMythicPlayerTeleportChunkNotLoaded(PlayerTeleportEvent e) {
        if (!e.isCancelled() && e.getPlayer().hasMetadata(meta_MYTHICPLAYER) && e.getFrom().getWorld().equals(e.getTo().getWorld())) {
            final Player p = e.getPlayer();
            new BukkitRunnable(){

                public void run() {
                    if (p.isDead()) {
                        Volatile.handler.setDeath(p, false);
                        Optional<ActivePlayer> maybeActivePlayer = PlayerManager.this.getActivePlayer(p.getUniqueId());
                        if (maybeActivePlayer.isPresent()) {
                            ActivePlayer ap = maybeActivePlayer.get();
                            PlayerManager.this.removeActivePlayer(ap);
                            new BukkitRunnable(){

                                public void run() {
                                    PlayerManager.this.attachActivePlayer((LivingEntity)p, true);
                                }
                            }.runTaskLater((Plugin)Main.getPlugin(), 20L);
                        }
                    }
                }
            }.runTaskLater((Plugin)Main.getPlugin(), 50L);
        }
    }

    @EventHandler
    public void onMythicPlayerChangeSlot(PlayerItemHeldEvent e) {
        if (e.isCancelled() || !e.getPlayer().hasMetadata(meta_MYTHICPLAYER)) {
            return;
        }
        Optional<ActivePlayer> maybeActivePlayer = this.getActivePlayer(e.getPlayer().getUniqueId());
        if (maybeActivePlayer.isPresent()) {
            ActivePlayer ap = maybeActivePlayer.get();
            e.getPlayer().setMetadata(meta_READYREASON, (MetadataValue)new FixedMetadataValue(this.mythicplayers.plugin(), (Object)meta_ITEMCHANGE));
            new TriggeredSkill(SkillTrigger.READY, (ActiveMob)ap, ap.getEntity(), true);
        }
    }
}

