/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.compatibility.quests;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.compatibility.quests.QuestCompleteCondition;
import com.gmail.berndivader.mythicmobsext.compatibility.quests.QuestRunningCondition;
import com.gmail.berndivader.mythicmobsext.compatibility.quests.QuestsMechanic;
import com.gmail.berndivader.mythicmobsext.compatibility.quests.TestRequirementCondition;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicConditionLoadEvent;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicMechanicLoadEvent;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import java.util.Iterator;
import java.util.Optional;
import me.blackvein.quests.Quest;
import me.blackvein.quests.Quester;
import me.blackvein.quests.Quests;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class QuestsSupport
implements Listener {
    static String pluginName = "Quests";
    private static QuestsSupport core;
    private Plugin plugin;
    private static Optional<Quests> quests;

    public QuestsSupport(Plugin plugin) {
        if (Bukkit.getPluginManager().getPlugin(quests.get().getName()).getDescription().getVersion().contains("3.9")) {
            core = this;
            this.plugin = plugin;
            Main.pluginmanager.registerEvents((Listener)this, plugin);
            Main.logger.info("using " + pluginName);
        } else {
            Main.logger.warning("Your Quests plugin version is too old, update it if you want to use it!");
        }
    }

    public static QuestsSupport inst() {
        return core;
    }

    public Plugin plugin() {
        return this.plugin;
    }

    public static boolean isPresent() {
        return quests.isPresent();
    }

    public Quests quests() {
        return quests.get();
    }

    @EventHandler
    public void onQuestConditionsLoad(MythicConditionLoadEvent e) {
        String s1;
        switch (s1 = e.getConditionName().toLowerCase()) {
            case "activequest": 
            case "activequest_ext": {
                e.register((SkillCondition)new QuestRunningCondition(e.getConditionName(), e.getConfig()));
                break;
            }
            case "completedquest": 
            case "completedquest_ext": {
                e.register((SkillCondition)new QuestCompleteCondition(e.getConditionName(), e.getConfig()));
                break;
            }
            case "testrequirement": 
            case "testrequirement_ext": {
                e.register((SkillCondition)new TestRequirementCondition(e.getConditionName(), e.getConfig()));
            }
        }
    }

    @EventHandler
    public void onQuestMechanicsLoad(MythicMechanicLoadEvent e) {
        String s1;
        switch (s1 = e.getMechanicName().toLowerCase()) {
            case "completequest": 
            case "takequest": 
            case "failquest": 
            case "completequest_ext": 
            case "takequest_ext": 
            case "failquest_ext": {
                e.register((SkillMechanic)new QuestsMechanic(e.getMechanicName(), e.getConfig()));
            }
        }
    }

    static Quest getQuestFromCurrent(Quester quester, String questName) {
        Iterator entries = quester.getCurrentQuests().entrySet().iterator();
        while (entries.hasNext()) {
            Quest quest = (Quest)entries.next().getKey();
            if (!quest.getName().toLowerCase().equals(questName)) continue;
            return quest;
        }
        return null;
    }

    static {
        quests = Optional.ofNullable((Quests)Bukkit.getServer().getPluginManager().getPlugin(pluginName));
    }
}

