/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.compatibility.worldguard;

import com.gmail.berndivader.mythicmobsext.compatibility.worldguard.Reflections;
import com.gmail.berndivader.mythicmobsext.utils.Vec3D;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.SetFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.StringFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Set;
import org.bukkit.Location;

public class WorldGuardUtils {
    static FlagRegistry flag_registery;
    static String global_name;

    static Set<ProtectedRegion> getRegionsByLocation(Location location) {
        Set regions = (Set)Reflections.getApplicableRegions(location.getWorld(), new Vec3D(location.getX(), location.getY(), location.getZ()));
        regions.add((ProtectedRegion)Reflections.getRegion(location.getWorld(), global_name));
        return regions;
    }

    public static boolean checkFlagAtLocation(Location location, String flag_name, String args) {
        Flag flag = flag_registery.get(flag_name);
        Set regions = (Set)Reflections.getApplicableRegions(location.getWorld(), new Vec3D(location.getX(), location.getY(), location.getZ()));
        if (regions.size() == 0) {
            regions.add((ProtectedRegion)Reflections.getRegion(location.getWorld(), global_name));
        }
        boolean bl1 = false;
        block5 : switch (flag.getClass().getSimpleName()) {
            case "StateFlag": {
                for (ProtectedRegion region : regions) {
                    StateFlag.State state = (StateFlag.State)region.getFlag((Flag)((StateFlag)flag));
                    bl1 = state != null && state == StateFlag.State.ALLOW;
                }
                break;
            }
            case "SetFlag": {
                switch (((SetFlag)flag).getType().getClass().getSimpleName()) {
                    case "RegistryFlag": 
                    case "EntityTypeFlag": {
                        String[] arr = args.split(",");
                        for (ProtectedRegion region : regions) {
                            Set entitytypes = (Set)region.getFlag(flag);
                            if (entitytypes == null) continue;
                            for (Object o1 : entitytypes) {
                                for (int i1 = 0; i1 < arr.length; ++i1) {
                                    if (!arr[i1].equals(Reflections.class_EntityType_getName(o1))) continue;
                                    return true;
                                }
                            }
                        }
                        break block5;
                    }
                }
                break;
            }
            case "StringFlag": {
                for (ProtectedRegion region : regions) {
                    String string = (String)region.getFlag((Flag)((StringFlag)flag));
                    if (!string.equals(args)) continue;
                    return true;
                }
                break;
            }
        }
        return bl1;
    }

    public static boolean checkRegionStateFlagAtLocation(Location l, String f, String action) {
        return WorldGuardUtils.checkFlagAtLocation(l, f, action);
    }

    public static boolean checkRegionDenySpawnFlagAtLocation(Location l, String entitylist) {
        return WorldGuardUtils.checkFlagAtLocation(l, "deny-spawn", entitylist);
    }

    static {
        global_name = "__global__";
        flag_registery = (FlagRegistry)Reflections.getFlagRegistry();
    }
}

