/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.conditions;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.conditions.AbstractCustomCondition;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.RangedDouble;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityComparisonCondition;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

@ExternalAnnotation(name="damageable,attackable", author="BerndiVader")
public class IsAttackableCondition
extends AbstractCustomCondition
implements IEntityComparisonCondition {
    private EntityDamageEvent.DamageCause cause = EntityDamageEvent.DamageCause.CUSTOM;
    boolean swap;
    RangedDouble damageRange;

    public IsAttackableCondition(String line, MythicLineConfig mlc) {
        super(line, mlc);
        String ca = mlc.getString(new String[]{"damagecause", "cause"}, "CUSTOM", new String[0]).toUpperCase();
        this.damageRange = new RangedDouble(mlc.getString("range", "-1"));
        this.swap = mlc.getBoolean("swap", false);
        for (EntityDamageEvent.DamageCause dc : EntityDamageEvent.DamageCause.values()) {
            if (!dc.toString().equals(ca)) continue;
            this.cause = dc;
            break;
        }
    }

    public boolean check(AbstractEntity source, AbstractEntity target) {
        if (this.swap) {
            AbstractEntity temp = source;
            source = target;
            target = temp;
        }
        if (source.getUniqueId().equals(target.getUniqueId())) {
            return true;
        }
        EntityDamageByEntityEvent event = new EntityDamageByEntityEvent(source.getBukkitEntity(), target.getBukkitEntity(), this.cause, 1.0);
        Bukkit.getPluginManager().callEvent((Event)event);
        boolean bl1 = !event.isCancelled();
        event.setCancelled(true);
        if (this.damageRange.equals(-1)) {
            return bl1;
        }
        LivingEntity livingTarget = (LivingEntity)target.getBukkitEntity();
        livingTarget.setMetadata("mme_dmg_chk", (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), (Object)true));
        livingTarget.damage(10.0, source.getBukkitEntity());
        double delta = ((MetadataValue)livingTarget.getMetadata("mme_dmg_amount").get(0)).asDouble() / 10.0;
        livingTarget.removeMetadata("mme_dmg_amount", (Plugin)Main.getPlugin());
        return bl1 && this.damageRange.equals(delta);
    }
}

