/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.items;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.NMS.NMSUtils;
import com.gmail.berndivader.mythicmobsext.backbags.BackBagHelper;
import com.gmail.berndivader.mythicmobsext.items.Enchant;
import com.gmail.berndivader.mythicmobsext.items.WhereEnum;
import com.gmail.berndivader.mythicmobsext.utils.RandomDouble;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import com.google.gson.JsonElement;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ModdingItem
implements Cloneable {
    ACTION action;
    WhereEnum where;
    Optional<Material> material;
    Optional<String[]> lore;
    Optional<String> name;
    Optional<RandomDouble> amount;
    Optional<List<Enchant>> enchants;
    Optional<String> durability;
    Optional<String> bag_name;
    Optional<String> slot;
    Optional<JsonElement> json_element;

    public ModdingItem(WhereEnum where, String slot, ACTION action, Material material, String[] lore_array, String name, RandomDouble amount, List<Enchant> enchants, String durability, String bag_name, JsonElement json_element) {
        this.where = where;
        this.action = action;
        this.material = Optional.ofNullable(material);
        this.lore = Optional.ofNullable(lore_array);
        this.name = Optional.ofNullable(name);
        this.amount = Optional.ofNullable(amount);
        this.enchants = Optional.ofNullable(enchants);
        this.setDurability(durability);
        this.bag_name = Optional.ofNullable(bag_name);
        this.slot = Optional.ofNullable(slot);
        this.json_element = Optional.ofNullable(json_element);
    }

    public void setSlot(String slot) {
        this.slot = Optional.ofNullable(slot);
    }

    public int getSlot(SkillMetadata data, AbstractEntity target) {
        return data != null ? (this.slot.isPresent() ? Integer.parseInt(PlaceholderString.of((String)this.slot.get()).get((PlaceholderMeta)data, target)) : -1) : (this.slot.isPresent() ? Integer.parseInt(PlaceholderString.of((String)this.slot.get()).get(target)) : -1);
    }

    public void setBagName(String bag_name) {
        this.bag_name = Optional.ofNullable(bag_name);
    }

    public String getBagName() {
        return this.bag_name.orElse(null);
    }

    public void setDurability(String durability) {
        this.durability = Optional.ofNullable(durability);
    }

    public ItemStack applyMods(SkillMetadata data, AbstractEntity target, ItemStack item_stack) {
        switch (this.action) {
            case SET: {
                if (this.material.isPresent()) {
                    item_stack.setType(this.material.get());
                }
                if (this.amount.isPresent()) {
                    item_stack.setAmount(this.amount.get().rollInteger());
                }
                if (this.name.isPresent()) {
                    String name = PlaceholderString.of((String)this.name.get()).get((PlaceholderMeta)data, target);
                    ItemMeta item_meta = item_stack.getItemMeta();
                    item_meta.setDisplayName(name);
                    item_stack.setItemMeta(item_meta);
                }
                if (this.lore.isPresent()) {
                    String[] lore = (String[])this.lore.get().clone();
                    int size = lore.length;
                    for (int i1 = 0; i1 < size; ++i1) {
                        String temp;
                        lore[i1] = temp = PlaceholderString.of((String)lore[i1]).get((PlaceholderMeta)data, target);
                    }
                    ItemMeta item_meta = item_stack.getItemMeta();
                    item_meta.setLore(Arrays.asList(lore));
                    item_stack.setItemMeta(item_meta);
                }
                if (this.enchants.isPresent()) {
                    List<Enchant> enchant_map = this.enchants.get();
                    ListIterator<Enchant> iter = enchant_map.listIterator();
                    item_stack.getEnchantments().clear();
                    while (iter.hasNext()) {
                        Enchant enchant = iter.next();
                        item_stack.addUnsafeEnchantment(enchant.enchantment, enchant.level.rollInteger());
                    }
                }
                if (this.durability.isPresent()) {
                    short duration = item_stack.getDurability();
                    String durability = PlaceholderString.of((String)this.durability.get()).get((PlaceholderMeta)data, target);
                    try {
                        duration = Short.parseShort(durability);
                    }
                    catch (Exception ex) {
                        Main.logger.warning("Error while parsing durability for " + durability);
                    }
                    item_stack.setDurability(duration);
                }
                if (!this.json_element.isPresent()) break;
                Object nbt = NMSUtils.getTag(item_stack);
                Utils.getTagValue(nbt, this.json_element.get());
                break;
            }
            case ADD: {
                if (this.amount.isPresent()) {
                    item_stack.setAmount(item_stack.getAmount() + this.amount.get().rollInteger());
                }
                if (this.name.isPresent()) {
                    String name = PlaceholderString.of((String)this.name.get()).get((PlaceholderMeta)data, target);
                    ItemMeta item_meta = item_stack.getItemMeta();
                    String old_name = item_meta.hasDisplayName() ? item_meta.getDisplayName() : "";
                    item_meta.setDisplayName(old_name + name);
                    item_stack.setItemMeta(item_meta);
                }
                if (this.lore.isPresent()) {
                    String[] lore = (String[])this.lore.get().clone();
                    int size = lore.length;
                    for (int i1 = 0; i1 < size; ++i1) {
                        lore[i1] = PlaceholderString.of((String)lore[i1]).get((PlaceholderMeta)data, target);
                    }
                    ItemMeta item_meta = item_stack.getItemMeta();
                    if (item_meta.hasLore()) {
                        List lores = item_meta.getLore();
                        lores.addAll(Arrays.asList(lore));
                        item_meta.setLore(lores);
                    } else {
                        item_meta.setLore(Arrays.asList(lore));
                    }
                    item_stack.setItemMeta(item_meta);
                }
                if (this.enchants.isPresent()) {
                    List<Enchant> enchant_map = this.enchants.get();
                    ListIterator<Enchant> iter = enchant_map.listIterator();
                    while (iter.hasNext()) {
                        Enchant enchant = iter.next();
                        item_stack.addUnsafeEnchantment(enchant.enchantment, enchant.level.rollInteger());
                    }
                }
                if (!this.durability.isPresent()) break;
                short duration = 0;
                String durability = PlaceholderString.of((String)this.durability.get()).get((PlaceholderMeta)data, target);
                try {
                    duration = Short.parseShort(durability);
                }
                catch (Exception ex) {
                    Main.logger.warning("Error while parsing durability for " + durability);
                }
                duration = (short)(duration + item_stack.getDurability());
                item_stack.setDurability(duration);
                break;
            }
            case DEL: {
                if (this.amount.isPresent()) {
                    int new_size = this.amount.get().rollInteger();
                    if (new_size >= item_stack.getAmount()) {
                        item_stack.setAmount(0);
                    } else {
                        item_stack.setAmount(item_stack.getAmount() - new_size);
                    }
                }
                if (this.name.isPresent() && item_stack.getItemMeta().hasDisplayName()) {
                    String name = PlaceholderString.of((String)this.name.get()).get((PlaceholderMeta)data, target);
                    ItemMeta item_meta = item_stack.getItemMeta();
                    String new_name = name;
                    String old_name = item_meta.getDisplayName();
                    item_meta.setDisplayName(old_name.replaceAll(new_name, ""));
                    item_stack.setItemMeta(item_meta);
                }
                if (this.lore.isPresent() && item_stack.getItemMeta().hasLore()) {
                    String[] lore = (String[])this.lore.get().clone();
                    int size = lore.length;
                    for (int i1 = 0; i1 < size; ++i1) {
                        lore[i1] = PlaceholderString.of((String)lore[i1]).get((PlaceholderMeta)data, target);
                    }
                    ItemMeta item_meta = item_stack.getItemMeta();
                    String[] lores = lore;
                    size = lores.length;
                    List lore_list = item_meta.getLore();
                    for (int i1 = 0; i1 < size; ++i1) {
                        if (!lore_list.contains(lores[i1])) continue;
                        lore_list.remove(lores[i1]);
                    }
                    item_meta.setLore(lore_list);
                    item_stack.setItemMeta(item_meta);
                }
                if (this.enchants.isPresent()) {
                    for (Enchant enchant : this.enchants.get()) {
                        if (!item_stack.containsEnchantment(enchant.enchantment)) continue;
                        item_stack.removeEnchantment(enchant.enchantment);
                    }
                    break;
                }
                if (!this.durability.isPresent()) break;
                short duration = 0;
                String durability = PlaceholderString.of((String)this.durability.get()).get((PlaceholderMeta)data, target);
                try {
                    duration = Short.parseShort(durability);
                }
                catch (Exception ex) {
                    Main.logger.warning("Error while parsing durability for " + durability);
                }
                duration = (short)(duration - item_stack.getDurability());
                item_stack.setDurability(duration);
            }
        }
        return item_stack;
    }

    public ItemStack getItemStackByWhere(SkillMetadata data, AbstractEntity target, LivingEntity entity) {
        switch (this.where) {
            case HAND: {
                ItemStack output = entity.getEquipment().getItemInMainHand();
                if (output == null || output.getType() == Material.AIR) break;
                return output;
            }
            case OFFHAND: {
                ItemStack output = entity.getEquipment().getItemInOffHand();
                if (output == null || output.getType() == Material.AIR) break;
                return output;
            }
            case HELMET: {
                ItemStack output = entity.getEquipment().getHelmet();
                if (output == null || output.getType() == Material.AIR) break;
                return output;
            }
            case CHESTPLATE: {
                ItemStack output = entity.getEquipment().getChestplate();
                if (output == null || output.getType() == Material.AIR) break;
                return output;
            }
            case LEGGINGS: {
                ItemStack output = entity.getEquipment().getLeggings();
                if (output == null || output.getType() == Material.AIR) break;
                return output;
            }
            case BOOTS: {
                ItemStack output = entity.getEquipment().getBoots();
                if (output == null || output.getType() == Material.AIR) break;
                return output;
            }
            case INVENTORY: {
                if (!(entity instanceof Player) || this.getSlot(data, target) <= -1) break;
                Player player = (Player)entity;
                int slot = this.getSlot(data, target);
                ItemStack output = player.getInventory().getItem(slot);
                if (output == null || output.getType() == Material.AIR) break;
                return output;
            }
            case BACKBAG: {
                ItemStack output;
                Inventory inventory;
                if (!BackBagHelper.hasBackBag(entity.getUniqueId()) || (inventory = BackBagHelper.getInventory(entity.getUniqueId(), this.bag_name.isPresent() ? this.bag_name.get() : BackBagHelper.str_name)) == null) break;
                int slot = this.getSlot(data, target);
                if (inventory.getSize() < slot || slot <= -1 || (output = inventory.getItem(slot)) == null || output.getType() == Material.AIR) break;
                return output;
            }
        }
        return null;
    }

    public static enum ACTION {
        SET,
        ADD,
        DEL;

    }
}

