/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.jboolexpr;

import com.gmail.berndivader.mythicmobsext.jboolexpr.Expression;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;

public class MathInterpreter {
    private static final Map<String, DoubleUnaryOperator> functions = new HashMap<String, DoubleUnaryOperator>();
    Map<String, Object> variables = new HashMap<String, Object>();

    public static Expression parse(final String str, final Map<String, Double> variables) {
        return new Object(){
            int pos = -1;
            int ch;

            void nextChar() {
                this.ch = ++this.pos < str.length() ? (int)str.charAt(this.pos) : -1;
            }

            boolean eat(int charToEat) {
                while (this.ch == 32) {
                    this.nextChar();
                }
                if (this.ch == charToEat) {
                    this.nextChar();
                    return true;
                }
                return false;
            }

            Expression parse() {
                this.nextChar();
                Expression x = this.parseExpression();
                if (this.pos < str.length()) {
                    throw new RuntimeException("Unexpected: " + (char)this.ch);
                }
                return x;
            }

            Expression parseExpression() {
                Expression x = this.parseTerm();
                while (true) {
                    Expression b;
                    Expression a2;
                    if (this.eat(43)) {
                        a2 = x;
                        b = this.parseTerm();
                        x = () -> a2.eval() + b.eval();
                        continue;
                    }
                    if (!this.eat(45)) break;
                    a2 = x;
                    b = this.parseTerm();
                    x = () -> a2.eval() - b.eval();
                }
                return x;
            }

            Expression parseTerm() {
                Expression x = this.parseFactor();
                while (true) {
                    Expression b;
                    Expression a2;
                    if (this.eat(42)) {
                        a2 = x;
                        b = this.parseFactor();
                        x = () -> a2.eval() * b.eval();
                        continue;
                    }
                    if (this.eat(47)) {
                        a2 = x;
                        b = this.parseFactor();
                        x = () -> a2.eval() / b.eval();
                        continue;
                    }
                    if (!this.eat(37)) break;
                    a2 = x;
                    b = this.parseFactor();
                    x = () -> a2.eval() % b.eval();
                }
                return x;
            }

            Expression parseFactor() {
                Expression x;
                if (this.eat(43)) {
                    return this.parseFactor();
                }
                if (this.eat(45)) {
                    Expression b = this.parseFactor();
                    return () -> -1.0 * b.eval();
                }
                int startPos = this.pos;
                if (this.eat(40)) {
                    x = this.parseExpression();
                    this.eat(41);
                } else if (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                    while (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                        this.nextChar();
                    }
                    double xx = Double.parseDouble(str.substring(startPos, this.pos));
                    x = () -> xx;
                } else if (this.ch >= 97 && this.ch <= 122) {
                    while (this.ch >= 97 && this.ch <= 122) {
                        this.nextChar();
                    }
                    String name = str.substring(startPos, this.pos);
                    if (functions.containsKey(name)) {
                        DoubleUnaryOperator func = (DoubleUnaryOperator)functions.get(name);
                        Expression arg = this.parseFactor();
                        x = () -> func.applyAsDouble(arg.eval());
                    } else {
                        x = () -> (Double)variables.get(name);
                    }
                } else {
                    throw new RuntimeException("Unexpected: " + (char)this.ch);
                }
                return x;
            }
        }.parse();
    }

    static {
        functions.put("log", x -> Math.log(x));
        functions.put("sqrt", x -> Math.sqrt(x));
        functions.put("sin", x -> Math.sin(x));
        functions.put("cos", x -> Math.cos(x));
        functions.put("tan", x -> Math.tan(x));
        functions.put("rnd", x -> Math.random() * x);
        functions.put("round", x -> Math.round(x));
        functions.put("floor", x -> Math.floor(x));
        functions.put("int", x -> (int)x);
        functions.put("unixtime", x -> (int)(System.currentTimeMillis() / 1000L));
    }
}

