/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.NMS.NMSUtils;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import java.util.Arrays;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Snowman;
import org.bukkit.inventory.ItemStack;

@ExternalAnnotation(name="damagearmor", author="BerndiVader")
public class DamageArmorMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected HashSet<String> armortype;
    protected int rndMin;
    protected int rndMax;
    protected String signal;

    public DamageArmorMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.armortype = new HashSet();
        this.armortype.addAll(Arrays.asList(mlc.getString(new String[]{"armor", "a", "armour"}, "all", new String[0]).toLowerCase().split(",")));
        String[] maybeRnd = mlc.getString(new String[]{"damage", "dmg", "d"}, "1", new String[0]).split("to");
        if (maybeRnd.length > 1) {
            this.rndMin = Integer.parseInt(maybeRnd[0]);
            this.rndMax = Integer.parseInt(maybeRnd[1]);
        } else {
            this.rndMin = Integer.parseInt(maybeRnd[0]);
            this.rndMax = Integer.parseInt(maybeRnd[0]);
        }
        this.signal = mlc.getString(new String[]{"signal", "s"}, null, new String[0]);
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        short dur;
        ItemStack armor;
        if (target == null || !target.isLiving() || target.isDead()) {
            return false;
        }
        if (target.getBukkitEntity().getType().equals((Object)EntityType.SNOWMAN)) {
            NMSUtils.setSnowmanPumpkin((Snowman)target.getBukkitEntity(), false);
        }
        LivingEntity e = (LivingEntity)BukkitAdapter.adapt((AbstractEntity)target);
        boolean broken = false;
        int damageValue = this.rndMin + (int)(Math.random() * (double)(this.rndMax - this.rndMin + 1));
        if (e.getEquipment() == null) {
            return false;
        }
        if (this.armortype.contains("offhand") || this.armortype.contains("all")) {
            armor = e.getEquipment().getItemInOffHand();
            dur = (short)(armor.getDurability() + damageValue);
            armor.setDurability(dur);
            if (armor.getDurability() > armor.getType().getMaxDurability()) {
                e.getEquipment().setItemInOffHand(new ItemStack(Material.AIR));
                broken = true;
            }
        }
        if (this.armortype.contains("hand") || this.armortype.contains("all")) {
            armor = e.getEquipment().getItemInMainHand();
            dur = (short)(armor.getDurability() + damageValue);
            armor.setDurability(dur);
            if (armor.getDurability() > armor.getType().getMaxDurability()) {
                e.getEquipment().setItemInMainHand(new ItemStack(Material.AIR));
                broken = true;
            } else {
                e.getEquipment().setItemInMainHand(new ItemStack(armor));
            }
        }
        if (this.armortype.contains("helmet") || this.armortype.contains("all")) {
            armor = e.getEquipment().getHelmet();
            dur = (short)(armor.getDurability() + damageValue);
            armor.setDurability(dur);
            if (armor.getDurability() > armor.getType().getMaxDurability()) {
                e.getEquipment().setHelmet(new ItemStack(Material.AIR));
                broken = true;
            } else {
                e.getEquipment().setHelmet(new ItemStack(armor));
            }
        }
        if (this.armortype.contains("chest") || this.armortype.contains("all")) {
            armor = e.getEquipment().getChestplate();
            dur = (short)(armor.getDurability() + damageValue);
            armor.setDurability(dur);
            if (armor.getDurability() > armor.getType().getMaxDurability()) {
                e.getEquipment().setChestplate(new ItemStack(Material.AIR));
                broken = true;
            } else {
                e.getEquipment().setChestplate(new ItemStack(armor));
            }
        }
        if (this.armortype.contains("leggings") || this.armortype.contains("all")) {
            armor = e.getEquipment().getLeggings();
            dur = (short)(armor.getDurability() + damageValue);
            armor.setDurability(dur);
            if (armor.getDurability() > armor.getType().getMaxDurability()) {
                e.getEquipment().setLeggings(new ItemStack(Material.AIR));
                broken = true;
            } else {
                e.getEquipment().setLeggings(new ItemStack(armor));
            }
        }
        if (this.armortype.contains("boots") || this.armortype.contains("all")) {
            armor = e.getEquipment().getBoots();
            dur = (short)(armor.getDurability() + damageValue);
            armor.setDurability(dur);
            if (armor.getDurability() > armor.getType().getMaxDurability()) {
                e.getEquipment().setBoots(new ItemStack(Material.AIR));
                broken = true;
            } else {
                e.getEquipment().setBoots(new ItemStack(armor));
            }
        }
        ActiveMob am = null;
        if (data.getCaster() instanceof ActiveMob) {
            am = (ActiveMob)data.getCaster();
        }
        if (am != null && broken && this.signal != null) {
            am.signalMob(BukkitAdapter.adapt((Entity)e), this.signal);
        }
        return true;
    }
}

