/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractItemStack;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.inventory.ItemStack;

@ExternalAnnotation(name="asequip", author="BerndiVader")
public class EquipArmorstandMechanic
extends SkillMechanic
implements INoTargetSkill {
    Optional<MythicItem> mythicItem;
    PlaceholderString item;
    Material material;
    String[] parse;
    int slot;
    int pos;

    public EquipArmorstandMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.parse = mlc.getString(new String[]{"item", "i"}).split(":");
        this.item = PlaceholderString.of((String)this.parse[0]);
        this.pos = Integer.parseInt(this.parse[1]);
    }

    public boolean cast(SkillMetadata data) {
        if (data.getCaster().getEntity().getBukkitEntity() instanceof ArmorStand) {
            AbstractEntity target = data.getCaster().getEntity();
            try {
                this.material = Material.valueOf((String)this.item.get((PlaceholderMeta)data, target));
            }
            catch (Exception e) {
                this.material = Material.DIRT;
            }
            if (this.parse.length == 2) {
                this.slot = this.pos;
            }
            this.mythicItem = Utils.mythicmobs.getItemManager().getItem(this.item.get((PlaceholderMeta)data, target));
            ArmorStand as = (ArmorStand)data.getCaster().getEntity().getBukkitEntity();
            ItemStack is = this.mythicItem.isPresent() ? BukkitAdapter.adapt((AbstractItemStack)this.mythicItem.get().generateItemStack(1)) : new ItemStack(this.material, 1);
            switch (this.slot) {
                case 0: {
                    as.setItemInHand(is);
                    break;
                }
                case 1: {
                    as.setBoots(is);
                    break;
                }
                case 2: {
                    as.setLeggings(is);
                    break;
                }
                case 3: {
                    as.setChestplate(is);
                    break;
                }
                case 4: {
                    as.setHelmet(is);
                    break;
                }
                case 5: {
                    as.getEquipment().setItemInOffHand(is);
                }
            }
            return true;
        }
        return false;
    }
}

