/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.RandomDouble;
import com.gmail.berndivader.mythicmobsext.utils.math.MathUtils;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;

@ExternalAnnotation(name="heal", author="BerndiVader")
public class HealExtended
extends SkillMechanic
implements ITargetedEntitySkill,
INoTargetSkill {
    double healByDistance;
    boolean incHealByDistance;
    boolean power;
    boolean percentage;
    boolean caster;
    boolean current;
    boolean loss;
    EntityRegainHealthEvent.RegainReason reason;
    PlaceholderString amountPlaceholder;

    public HealExtended(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        double d;
        this.amountPlaceholder = PlaceholderString.of((String)mlc.getString("amount", "0"));
        this.power = mlc.getBoolean("power", false);
        this.percentage = mlc.getBoolean("percent", false);
        this.caster = mlc.getBoolean("caster", false);
        this.current = mlc.getBoolean("current", false);
        this.loss = mlc.getBoolean("loss", false);
        if (this.loss) {
            this.current = false;
        }
        this.healByDistance = mlc.getDouble("dec", 0.0) * -1.0;
        this.healByDistance = mlc.getDouble("inc", this.healByDistance);
        this.incHealByDistance = d < 0.0;
        this.healByDistance = Math.abs(this.healByDistance);
        String reasonString = mlc.getString("reason", "custom").toUpperCase();
        this.reason = EntityRegainHealthEvent.RegainReason.CUSTOM;
        for (EntityRegainHealthEvent.RegainReason value : EntityRegainHealthEvent.RegainReason.values()) {
            if (!value.toString().equals(reasonString)) continue;
            this.reason = value;
            break;
        }
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity abstract_target) {
        if (!(abstract_target.getBukkitEntity() instanceof LivingEntity)) {
            return false;
        }
        LivingEntity t = (LivingEntity)abstract_target.getBukkitEntity();
        LivingEntity c = (LivingEntity)data.getCaster().getEntity().getBukkitEntity();
        double amount = new RandomDouble(this.amountPlaceholder.get((PlaceholderMeta)data, abstract_target)).rollDouble();
        AbstractEntity abstract_caster = data.getCaster().getEntity();
        if (this.percentage) {
            double d = this.current ? (this.caster ? c.getHealth() * amount : t.getHealth() * amount) : (this.loss ? (this.caster ? (c.getMaxHealth() - c.getHealth()) * amount : (t.getMaxHealth() - t.getHealth()) * amount) : (amount = this.caster ? c.getMaxHealth() * amount : t.getMaxHealth() * amount));
        }
        if (this.power) {
            amount *= (double)data.getPower();
        }
        if (this.healByDistance > 0.0) {
            int distance = (int)Math.sqrt(MathUtils.distance3D(abstract_caster.getBukkitEntity().getLocation().toVector(), abstract_target.getBukkitEntity().getLocation().toVector()));
            amount = this.incHealByDistance ? amount - amount * ((double)distance * this.healByDistance) : amount + amount * ((double)distance * this.healByDistance);
        }
        EntityRegainHealthEvent event = new EntityRegainHealthEvent((Entity)t, amount, this.reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            t.setHealth(MathUtils.clamp(t.getHealth() + event.getAmount(), 0.0, t.getMaxHealth()));
        }
        return true;
    }

    public boolean cast(SkillMetadata data) {
        return this.castAtEntity(data, data.getCaster().getEntity());
    }
}

