/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.IParentSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.auras.Aura;
import io.lumine.xikage.mythicmobs.utils.Events;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.terminable.Terminable;
import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.event.inventory.InventoryClickEvent;

@ExternalAnnotation(name="ontrade", author="Seyarada")
public class OnTrade
extends Aura
implements ITargetedEntitySkill {
    protected Optional<Skill> onTradeSkill = Optional.empty();
    protected String onTradeSkillName;
    protected boolean cancelEvent;
    protected boolean forceAsPower;
    protected int oldXP;
    protected int newXP;

    public OnTrade(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.onTradeSkillName = mlc.getString(new String[]{"ontradeskill", "ontrade", "os", "s", "skill"});
        this.cancelEvent = mlc.getBoolean(new String[]{"cancelevent", "ce"}, false);
        this.forceAsPower = mlc.getBoolean(new String[]{"forceaspower", "fap"}, true);
        MythicMobs.inst().getSkillManager().queueSecondPass(() -> {
            if (this.onTradeSkillName != null) {
                this.onTradeSkill = MythicMobs.inst().getSkillManager().getSkill(this.onTradeSkillName);
            }
        });
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Tracker(data, target);
        return true;
    }

    private class Tracker
    extends Aura.AuraTracker
    implements IParentSkill,
    Runnable {
        public Tracker(SkillMetadata data, AbstractEntity entity) {
            super((Aura)OnTrade.this, entity, data);
            this.start();
        }

        public void auraStart() {
            this.registerAuraComponent((Terminable)Events.subscribe(InventoryClickEvent.class).filter(event -> {
                if (event.getInventory().getHolder() != null && ((Entity)event.getInventory().getHolder()).getType().equals((Object)EntityType.VILLAGER)) {
                    OnTrade.this.oldXP = ((Villager)((Entity)event.getInventory().getHolder())).getVillagerExperience();
                    return ((Entity)event.getInventory().getHolder()).getUniqueId().equals(((AbstractEntity)this.entity.get()).getUniqueId());
                }
                return false;
            }).handler(event -> {
                if (event.getInventory().getHolder() != null && ((Entity)event.getInventory().getHolder()).getType().equals((Object)EntityType.VILLAGER)) {
                    Schedulers.sync().runLater(() -> {
                        OnTrade.this.newXP = ((Villager)((Entity)event.getInventory().getHolder())).getVillagerExperience();
                        if (OnTrade.this.newXP != OnTrade.this.oldXP) {
                            SkillMetadata meta = this.skillMetadata.deepClone();
                            meta.setEntityTarget(BukkitAdapter.adapt((Entity)((Entity)event.getInventory().getHolder())));
                            if (this.executeAuraSkill(OnTrade.this.onTradeSkill, meta) && OnTrade.this.cancelEvent) {
                                event.setCancelled(true);
                            }
                        }
                    }, 1L);
                }
            }));
            this.executeAuraSkill(OnTrade.this.onStartSkill, this.skillMetadata);
        }
    }
}

