/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.backbags.InventoryViewer;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;

@ExternalAnnotation(name="snoopinventory,openinventory", author="BerndiVader")
public class SnoopInventory
extends SkillMechanic
implements ITargetedEntitySkill {
    boolean view_only;
    boolean snoop;
    InventoryType type;

    public SnoopInventory(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.snoop = mlc.getLine().toLowerCase().startsWith("snoop");
        this.view_only = mlc.getBoolean("viewonly", true);
        try {
            this.type = InventoryType.valueOf((String)mlc.getString("type", "PLAYER").toUpperCase());
        }
        catch (Exception ex) {
            this.type = InventoryType.PLAYER;
        }
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity abstract_entity) {
        if (this.snoop) {
            if (data.getCaster().getEntity().isPlayer() && abstract_entity.isPlayer()) {
                Player caster = (Player)data.getCaster().getEntity().getBukkitEntity();
                Player victim = (Player)abstract_entity.getBukkitEntity();
                new InventoryViewer(victim, caster);
            }
        } else if (data.getCaster().getEntity().isPlayer()) {
            Player caster = (Player)data.getCaster().getEntity().getBukkitEntity();
            new InventoryViewer(caster, caster, this.view_only, this.type);
        }
        return true;
    }
}

