/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.volatilecode.Volatile;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@ExternalAnnotation(name="stun,stun_ext", author="BerndiVader")
public class StunextMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private int duration;
    private boolean f;
    private boolean g;
    private boolean ai;
    private boolean useDuration;
    private boolean cancel_interaction;
    private boolean use_stun;
    static List<UUID> uuids = new ArrayList<UUID>();

    public StunextMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.duration = mlc.getInteger(new String[]{"duration", "dur"}, 120);
        this.f = mlc.getBoolean(new String[]{"facing", "face", "f"}, false);
        this.g = mlc.getBoolean(new String[]{"gravity", "g"}, false);
        this.ai = mlc.getBoolean(new String[]{"stopai", "ai"}, false);
        this.useDuration = mlc.getBoolean("useDuration", true);
        this.use_stun = mlc.getBoolean("usestun", true);
        this.cancel_interaction = mlc.getBoolean("cancelinteract", false);
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isLiving() && !target.getBukkitEntity().hasMetadata("mmeStunned")) {
            new StunTracker(target.getLocation(), target, this.duration);
            return true;
        }
        return false;
    }

    @EventHandler
    public void cancelInventoryClick(InventoryClickEvent e) {
        if (uuids.contains(e.getWhoClicked().getUniqueId())) {
            e.setCancelled(true);
        }
    }

    static boolean checkForEntity(LivingEntity target, LivingEntity final_target) {
        return target.getUniqueId() == final_target.getUniqueId();
    }

    class StunTracker
    extends BukkitRunnable
    implements Listener {
        long count = 0L;
        long duration;
        float yaw;
        float pitch;
        double x;
        double y;
        double z;
        boolean facing;
        boolean gravity;
        boolean ai;
        boolean ai_status;
        final LivingEntity final_target;
        final Location final_location;

        public StunTracker(AbstractLocation location, AbstractEntity target, long duration) {
            this.duration = duration;
            this.yaw = location.getYaw();
            this.pitch = location.getPitch();
            this.x = location.getX();
            this.y = location.getY();
            this.z = location.getZ();
            this.final_target = (LivingEntity)target.getBukkitEntity();
            this.final_location = BukkitAdapter.adapt((AbstractLocation)location).clone();
            if (this.final_target.hasMetadata("mmeStunned")) {
                target.getBukkitEntity().removeMetadata("mmeStunned", (Plugin)Main.getPlugin());
            }
            if (this.final_target.hasMetadata("mmeStunnedTime")) {
                target.getBukkitEntity().removeMetadata("mmeStunnedTime", (Plugin)Main.getPlugin());
            }
            this.facing = StunextMechanic.this.f;
            this.gravity = StunextMechanic.this.g;
            this.ai = StunextMechanic.this.ai;
            target.getBukkitEntity().setMetadata("mmeStunned", (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), (Object)true));
            target.getBukkitEntity().setMetadata("mmeStunnedTime", (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), (Object)duration));
            this.ai_status = this.final_target.hasAI();
            if (StunextMechanic.this.cancel_interaction) {
                if (uuids.contains(this.final_target.getUniqueId())) {
                    uuids.remove(this.final_target.getUniqueId());
                }
                uuids.add(this.final_target.getUniqueId());
                Main.pluginmanager.registerEvents((Listener)this, (Plugin)Main.getPlugin());
            }
            target.getBukkitEntity().setMetadata("mmeStunned", (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), (Object)true));
            target.getBukkitEntity().setMetadata("mmeStunnedTime", (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), (Object)duration));
            this.runTaskTimer((Plugin)Main.getPlugin(), 0L, 0L);
        }

        public void run() {
            if (this.final_target == null || this.final_target.isDead() || this.count > this.duration || !this.final_target.hasMetadata("mmeStunned")) {
                if (this.final_target != null && !this.final_target.isDead()) {
                    this.final_target.removeMetadata("mmeStunned", (Plugin)Main.getPlugin());
                    this.final_target.removeMetadata("mmeStunnedTime", (Plugin)Main.getPlugin());
                    this.final_target.setAI(this.ai_status);
                }
                HandlerList.unregisterAll((Listener)this);
                uuids.remove(this.final_target.getUniqueId());
                this.cancel();
            } else {
                if (StunextMechanic.this.use_stun) {
                    if (this.final_target.hasAI() && this.final_target.isOnGround()) {
                        this.final_target.setAI(false);
                    }
                    if (this.facing) {
                        this.yaw = this.final_target.getLocation().getYaw();
                        this.pitch = this.final_target.getLocation().getPitch();
                    }
                    if (this.gravity) {
                        this.y = this.final_target.getLocation().getY();
                    }
                    Volatile.handler.forceSetPositionRotation((Entity)this.final_target, this.x, this.y, this.z, this.yaw, this.pitch, this.facing, this.gravity);
                }
                this.final_target.removeMetadata("mmeStunnedTime", (Plugin)Main.getPlugin());
                this.final_target.setMetadata("mmeStunnedTime", (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), (Object)((long)((int)this.duration) - this.count)));
            }
            if (StunextMechanic.this.useDuration) {
                ++this.count;
            }
        }

        @EventHandler(priority=EventPriority.LOW)
        public void cancelClickEvent(InventoryClickEvent e) {
            e.setCancelled(StunextMechanic.checkForEntity((LivingEntity)e.getWhoClicked(), this.final_target));
        }

        @EventHandler(priority=EventPriority.LOW)
        public void cancelDragEvent(InventoryDragEvent e) {
            e.setCancelled(StunextMechanic.checkForEntity((LivingEntity)e.getWhoClicked(), this.final_target));
        }

        @EventHandler(priority=EventPriority.LOW)
        public void cancelHotbarEvent(PlayerItemHeldEvent e) {
            e.setCancelled(StunextMechanic.checkForEntity((LivingEntity)e.getPlayer(), this.final_target));
        }

        @EventHandler(priority=EventPriority.LOW)
        public void cancelConsumeEvent(PlayerItemConsumeEvent e) {
            e.setCancelled(StunextMechanic.checkForEntity((LivingEntity)e.getPlayer(), this.final_target));
        }

        @EventHandler(priority=EventPriority.LOW)
        public void cancelPickUpEvent(PlayerPickupItemEvent e) {
            e.setCancelled(StunextMechanic.checkForEntity((LivingEntity)e.getPlayer(), this.final_target));
        }

        @EventHandler(priority=EventPriority.LOW)
        public void cancelDropEvent(PlayerDropItemEvent e) {
            e.setCancelled(StunextMechanic.checkForEntity((LivingEntity)e.getPlayer(), this.final_target));
        }
    }
}

