/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.utils.math;

import com.gmail.berndivader.mythicmobsext.utils.Utils;
import com.gmail.berndivader.mythicmobsext.utils.Vec2D;
import com.gmail.berndivader.mythicmobsext.utils.Vec3D;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public final class MathUtils {
    private static BlockFace[] axis = new BlockFace[]{BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH, BlockFace.EAST};
    private static BlockFace[] radial = new BlockFace[]{BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST, BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST};
    public static final float DEGTORAD = (float)Math.PI / 180;
    public static final float RADTODEG = 57.29578f;
    public static final double SAFE_MIN = Double.MIN_NORMAL;

    private MathUtils() {
    }

    public static float getLookAtYaw(Entity loc, Entity lookat) {
        return MathUtils.getLookAtYaw(loc.getLocation(), lookat.getLocation());
    }

    public static float getLookAtYaw(Block loc, Block lookat) {
        return MathUtils.getLookAtYaw(loc.getLocation(), lookat.getLocation());
    }

    public static float getLookAtYaw(Location loc, Location lookat) {
        return MathUtils.getLookAtYaw(lookat.getX() - loc.getX(), lookat.getZ() - loc.getZ());
    }

    public static float getLookAtYaw(Vector motion) {
        return MathUtils.getLookAtYaw(motion.getX(), motion.getZ());
    }

    public static float getLookAtYaw(double dx, double dz) {
        float yaw = 0.0f;
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 270.0f : 90.0f;
            yaw -= MathUtils.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = 180.0f;
        }
        return -yaw - 90.0f;
    }

    public static Vector rotate(float yaw, float pitch, Vector value) {
        return MathUtils.rotate(yaw, pitch, value.getX(), value.getY(), value.getZ());
    }

    public static Vector rotate(float yaw, float pitch, double x, double y, double z) {
        float angle = yaw * ((float)Math.PI / 180);
        double sinyaw = Math.sin(angle);
        double cosyaw = Math.cos(angle);
        angle = pitch * ((float)Math.PI / 180);
        double sinpitch = Math.sin(angle);
        double cospitch = Math.cos(angle);
        double newx = 0.0;
        double newy = 0.0;
        double newz = 0.0;
        newz -= x * cosyaw;
        newz -= y * sinyaw * sinpitch;
        newx += x * sinyaw;
        newx -= y * cosyaw * sinpitch;
        newy += y * cospitch;
        return new Vector(newx -= z * cosyaw * cospitch, newy -= z * sinpitch, newz -= z * sinyaw * cospitch);
    }

    public static float normalise(float v, float s, float e) {
        float w = e - s;
        float o = v - s;
        return (float)((double)o - Math.floor(o / w) * (double)w + (double)s);
    }

    public static Location move(Location loc, Vector offset) {
        return MathUtils.move(loc, offset.getX(), offset.getY(), offset.getZ());
    }

    public static Location move(Location loc, double dx, double dy, double dz) {
        Vector off = MathUtils.rotate(loc.getYaw(), loc.getPitch(), dx, dy, dz);
        double x = loc.getX() + off.getX();
        double y = loc.getY() + off.getY();
        double z = loc.getZ() + off.getZ();
        return new Location(loc.getWorld(), x, y, z, loc.getYaw(), loc.getPitch());
    }

    private static float atan(double value) {
        return 57.29578f * (float)Math.atan(value);
    }

    public static int divisorMod(int a2, int n) {
        return (int)((double)a2 - (double)n * Math.floor(Math.floor(a2) / (double)n));
    }

    public static double dCos(double degrees) {
        int dInt = (int)degrees;
        if (degrees == (double)dInt && dInt % 90 == 0) {
            if ((dInt %= 360) < 0) {
                dInt += 360;
            }
            switch (dInt) {
                case 0: {
                    return 1.0;
                }
                case 90: {
                    return 0.0;
                }
                case 180: {
                    return -1.0;
                }
                case 270: {
                    return 0.0;
                }
            }
        }
        return Math.cos(Math.toRadians(degrees));
    }

    public static double dSin(double degrees) {
        int dInt = (int)degrees;
        if (degrees == (double)dInt && dInt % 90 == 0) {
            if ((dInt %= 360) < 0) {
                dInt += 360;
            }
            switch (dInt) {
                case 0: {
                    return 0.0;
                }
                case 90: {
                    return 1.0;
                }
                case 180: {
                    return 0.0;
                }
                case 270: {
                    return -1.0;
                }
            }
        }
        return Math.sin(Math.toRadians(degrees));
    }

    public static double lerp(double point1, double point2, double alpha) {
        return point1 + alpha * (point2 - point1);
    }

    public static float smoothstep(float f, boolean clamp) {
        float ff = f * f * (3.0f - 2.0f * f);
        return MathUtils.clamp(ff, clamp);
    }

    public static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    public static double clamp(double val, double min, double max) {
        return Math.max(min, Math.min(max, val));
    }

    public static float clamp(float y, boolean clamp) {
        return clamp ? (y < 0.0f ? 0.0f : (y > 1.0f ? 1.0f : y)) : y;
    }

    public static double clamp(double y, boolean clamp) {
        return clamp ? (y < 0.0 ? 0.0 : (y > 1.0 ? 1.0 : y)) : y;
    }

    public static float normalize(float value, float min, float max) {
        float delta = value - min;
        float delta_1 = max - min;
        return delta / delta_1;
    }

    public static double normalize(double value, double min, double max) {
        double delta = value - min;
        double delta_1 = max - min;
        return delta / delta_1;
    }

    public static double scale(double value, double min, double max) {
        return value / (max - min) + min;
    }

    public static boolean isNumeric(String s) {
        return s != null ? s.matches("[0-9]*") : false;
    }

    public static Vector calculateVelocity(Vector from, Vector to, double gravity, double heightGain) {
        int endGain = to.getBlockY() - from.getBlockY();
        double horizDist = Math.sqrt(MathUtils.distanceSquared(from, to));
        double maxGain = heightGain > (double)endGain + heightGain ? heightGain : (double)endGain + heightGain;
        double a2 = -horizDist * horizDist / (4.0 * maxGain);
        double b = horizDist;
        double c = -endGain;
        double slope = -b / (2.0 * a2) - Math.sqrt(b * b - 4.0 * a2 * c) / (2.0 * a2);
        double vy = Math.sqrt(maxGain * (gravity + 0.0013675090252708 * heightGain));
        double vh = vy / slope;
        int dx = to.getBlockX() - from.getBlockX();
        int dz = to.getBlockZ() - from.getBlockZ();
        double mag = Math.sqrt(dx * dx + dz * dz);
        double dirx = (double)dx / mag;
        double dirz = (double)dz / mag;
        double vx = vh * dirx;
        double vz = vh * dirz;
        return new Vector(vx, vy, vz);
    }

    private static double distanceSquared(Vector from, Vector to) {
        double dx = to.getBlockX() - from.getBlockX();
        double dz = to.getBlockZ() - from.getBlockZ();
        return dx * dx + dz * dz;
    }

    public static Vector spread(Vector from, double yaw, double pitch) {
        Vector vec = from.clone();
        float cosyaw = (float)Math.cos(yaw);
        float cospitch = (float)Math.cos(pitch);
        float sinyaw = (float)Math.sin(yaw);
        float sinpitch = (float)Math.sin(pitch);
        float bX = (float)(vec.getY() * (double)sinpitch + vec.getX() * (double)cospitch);
        float bY = (float)(vec.getY() * (double)cospitch - vec.getX() * (double)sinpitch);
        return new Vector((double)(bX * cosyaw) - vec.getZ() * (double)sinyaw, (double)bY, (double)(bX * sinyaw) + vec.getZ() * (double)cosyaw);
    }

    public static double launchAngle(Location from, Vector to, double v, double elev, double g) {
        double derp;
        Vector victor = from.toVector().subtract(to);
        Double dist = Math.sqrt(Math.pow(victor.getX(), 2.0) + Math.pow(victor.getZ(), 2.0));
        double v2 = Math.pow(v, 2.0);
        double v4 = Math.pow(v, 4.0);
        if (v4 < (derp = g * (g * Math.pow(dist, 2.0) + 2.0 * elev * v2))) {
            return Math.atan((2.0 * g * elev + v2) / (2.0 * g * elev + 2.0 * v2));
        }
        return Math.atan((v2 - Math.sqrt(v4 - derp)) / (g * dist));
    }

    public static double hangtime(double launchAngle, double v, double elev, double g) {
        double a2 = v * Math.sin(launchAngle);
        double b = -2.0 * g * elev;
        if (Math.pow(a2, 2.0) + b < 0.0) {
            return 0.0;
        }
        return (a2 + Math.sqrt(Math.pow(a2, 2.0) + b)) / g;
    }

    public static Vec2D calculateDirectionVec2D(Vec3D target_position, float velocity, float G) {
        double x = target_position.getX();
        double y = target_position.getY();
        double z = target_position.getZ();
        float yaw = (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
        double distance = Math.sqrt(x * x + z * z);
        float pitch = (float)(-Math.toDegrees(Math.atan(((double)(velocity * velocity) - Math.sqrt((float)((double)(velocity * velocity * velocity * velocity) - (double)G * ((double)G * (distance * distance) + 2.0 * y * (double)(velocity * velocity))))) / ((double)G * distance))));
        return new Vec2D(yaw, pitch);
    }

    public static Vector calculateDirectionVector(Vec3D target_position, float velocity, float G) {
        Vec2D vec2d = MathUtils.calculateDirectionVec2D(target_position, velocity, G);
        return MathUtils.getDirection((float)vec2d.getX(), (float)vec2d.getY());
    }

    public static Vector getDirection(float yaw, float pitch) {
        Vector vector = new Vector();
        double rotX = (float)Math.PI / 180 * yaw;
        double rotY = (float)Math.PI / 180 * pitch;
        vector.setY(-Math.sin(rotY));
        double h = Math.cos(rotY);
        vector.setX(-h * Math.sin(rotX));
        vector.setZ(h * Math.cos(rotX));
        return vector;
    }

    public static BlockFace getBlockFacing(float y, boolean bl1) {
        return bl1 ? radial[Math.round(y / 45.0f) & 7] : axis[Math.round(y / 90.0f) & 3];
    }

    @Deprecated
    public static Vector getSideOffsetVector(float vYa, double hO, boolean iy) {
        double y = 0.0;
        if (!iy) {
            y = Math.toRadians(vYa);
        }
        double xo = Math.cos(y) * hO;
        double zo = Math.sin(y) * hO;
        return new Vector(xo, 0.0, zo);
    }

    public static Vector getSideOffsetVectorFixed(float vYa, double hO, boolean iy) {
        double y = 0.0;
        if (!iy) {
            y = Math.toRadians(vYa);
        }
        double xo = Math.cos(y) * hO;
        double zo = Math.sin(y) * hO;
        return new Vector(xo, y, zo);
    }

    public static Vector getFrontBackOffsetVector(Vector v, double o) {
        Vector d = v.clone();
        d.normalize();
        d.multiply(o);
        return d;
    }

    public static Vector getForwardOffsetVector(Location location, double length) {
        return location.getDirection().clone().multiply(length);
    }

    public static float lookAtYaw(Location loc, Location lookat) {
        loc = loc.clone();
        lookat = lookat.clone();
        float yaw = 0.0f;
        double dx = lookat.getX() - loc.getX();
        double dz = lookat.getZ() - loc.getZ();
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.712389f : 1.5707964f;
            yaw -= (float)Math.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = (float)Math.PI;
        }
        yaw = -yaw * 180.0f / (float)Math.PI;
        return yaw;
    }

    public static Vec2D lookAtVec(Vector loc, Vector lookat) {
        float yaw = 0.0f;
        double dx = lookat.getX() - loc.getX();
        double dz = lookat.getZ() - loc.getZ();
        double dy = lookat.getY() - loc.getY();
        double dxz = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dz, 2.0));
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.712389f : 1.5707964f;
            yaw -= (float)Math.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = (float)Math.PI;
        }
        float pitch = (float)(-Math.atan(dy / dxz));
        return new Vec2D((double)(-yaw * 180.0f) / Math.PI, (double)(pitch * 180.0f) / Math.PI);
    }

    public static Vec2D lookAtVec(Location loc, Location lookat) {
        float yaw;
        loc = loc.clone();
        lookat = lookat.clone();
        float pitch = yaw = 0.0f;
        double dx = lookat.getX() - loc.getX();
        double dz = lookat.getZ() - loc.getZ();
        double dy = lookat.getY() - loc.getY();
        double dxz = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dz, 2.0));
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.712389f : 1.5707964f;
            yaw -= (float)Math.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = (float)Math.PI;
        }
        pitch = (float)(-Math.atan(dy / dxz));
        return new Vec2D((double)(-yaw * 180.0f) / Math.PI, (double)(pitch * 180.0f) / Math.PI);
    }

    public static Location moveTo(Location loc, Vector offset) {
        float ryaw = -loc.getYaw() / 180.0f * (float)Math.PI;
        float rpitch = loc.getPitch() / 180.0f * (float)Math.PI;
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        z -= offset.getX() * Math.sin(ryaw);
        z += offset.getY() * Math.cos(ryaw) * Math.sin(rpitch);
        x += offset.getX() * Math.cos(ryaw);
        x += offset.getY() * Math.sin(rpitch) * Math.sin(ryaw);
        y += offset.getY() * Math.cos(rpitch);
        return new Location(loc.getWorld(), x += offset.getZ() * Math.sin(ryaw) * Math.cos(rpitch), y -= offset.getZ() * Math.sin(rpitch), z += offset.getZ() * Math.cos(ryaw) * Math.cos(rpitch), loc.getYaw(), loc.getPitch());
    }

    public static AbstractLocation getCircleLoc(Location c, double rX, double rZ, double rY, double air) {
        double x = c.getX() + rX * Math.cos(air);
        double z = c.getZ() + rZ * Math.sin(air);
        double y = c.getY() + rY * Math.cos(air);
        Location loc = new Location(c.getWorld(), x, y, z);
        Vector difference = c.toVector().clone().subtract(loc.toVector());
        loc.setDirection(difference);
        return BukkitAdapter.adapt((Location)loc);
    }

    public static double round(double value, int places) {
        return new BigDecimal(value).round(new MathContext(places, RoundingMode.HALF_UP)).doubleValue();
    }

    public static double distance2D(Vector f, Vector t) {
        double dx = t.getBlockX() - f.getBlockX();
        double dz = t.getBlockZ() - f.getBlockZ();
        return dx * dx + dz * dz;
    }

    public static double distance3D(Vector f, Vector t) {
        double dx = t.getBlockX() - f.getBlockX();
        double dy = t.getBlockY() - f.getBlockY();
        double dz = t.getBlockZ() - f.getBlockZ();
        return dx * dx + dz * dz + dy * dy;
    }

    public static double distance3D(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0);
    }

    public static double distance2D(double x1, double z1, double x2, double z2) {
        return Math.pow(x1 - x2, 2.0) + Math.pow(z1 - z2, 2.0);
    }

    public static Location getLocationInFront(Location start, double range) {
        return start.clone().add(start.getDirection().setY(0).normalize().multiply(range));
    }

    public static int randomRangeInt(String range) {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        int amount = 0;
        if (range.contains("to")) {
            String[] split = range.split("to");
            int min = Integer.parseInt(split[0]);
            int max = Integer.parseInt(split[1]);
            if (max < min) {
                max = min;
            }
            amount = r.nextInt(min, max + 1);
        } else {
            amount = Integer.parseInt(range);
        }
        return amount;
    }

    public static double randomRangeDouble(String range) {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        double amount = 0.0;
        if (range.contains("to")) {
            String[] split = range.split("to");
            double min = Double.parseDouble(split[0]);
            double max = Double.parseDouble(split[1]);
            if (max < min) {
                max = min;
            }
            amount = r.nextDouble(min, max);
        } else {
            amount = Double.parseDouble(range);
        }
        return amount;
    }

    public static byte encodeAngle(float angle) {
        return (byte)(angle * 256.0f / 360.0f);
    }

    public static int encodeVelocity(double v) {
        return (int)(v * 8000.0);
    }

    public static long encodePosition(double d) {
        return (long)(d * 4096.0);
    }

    public static boolean isHeadingTo(Vector offset, Vector velocity) {
        double dbefore = offset.lengthSquared();
        if (dbefore < 1.0E-4) {
            return true;
        }
        Vector clonedVelocity = velocity.clone();
        MathUtils.setVecLenSqrt(clonedVelocity, dbefore);
        return dbefore > clonedVelocity.subtract(offset).lengthSquared();
    }

    public static void setVecLen(Vector vector, double length) {
        MathUtils.setVecLenSqrt(vector, Math.signum(length) * length * length);
    }

    public static void setVecLenSqrt(Vector vector, double lengthsquared) {
        double vlength = vector.lengthSquared();
        if (Math.abs(vlength) > 1.0E-4) {
            if (lengthsquared < 0.0) {
                vector.multiply(-Math.sqrt(-lengthsquared / vlength));
            } else {
                vector.multiply(Math.sqrt(lengthsquared / vlength));
            }
        }
    }

    public static boolean playerInMotion(Player p) {
        Vec3D v3 = Utils.players.get(p.getUniqueId());
        return Math.abs(v3.getX()) > 0.0 || Math.abs(v3.getY()) > 0.0 || Math.abs(v3.getZ()) >= 0.0;
    }

    public static boolean inCubiod(Location source, Location edge_1, Location edge_2) {
        double edge_1x = edge_1.getX();
        double edge_1y = edge_1.getX();
        double edge_1z = edge_1.getZ();
        double edge_2x = edge_2.getX();
        double edge_2y = edge_2.getX();
        double edge_2z = edge_2.getZ();
        Vector max = new Vector(Math.max(edge_1x, edge_2x), Math.max(edge_1y, edge_2y), Math.max(edge_1z, edge_2z));
        Vector min = new Vector(Math.min(edge_1x, edge_2x), Math.min(edge_1y, edge_2y), Math.min(edge_1z, edge_2z));
        return source.toVector().isInAABB(min, max);
    }
}

