/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.backbags;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.NMS.NMSUtils;
import com.gmail.berndivader.mythicmobsext.backbags.BackBagHelper;
import com.gmail.berndivader.mythicmobsext.backbags.BackBagInventory;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.GenericCaster;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class BackBagViewer
implements Listener {
    Entity owner;
    Player viewer;
    BackBagInventory inventory;
    private int size;
    String name;
    boolean only_view;
    List<Integer> excludes_slots;
    static int backbag_counter = 0;

    public BackBagViewer(Entity onwer) {
        this(onwer, 9);
    }

    public BackBagViewer(Entity onwer, String name) {
        this(onwer, 9, null, name, false);
    }

    public BackBagViewer(Entity owner, int size) {
        this(owner, size, null);
    }

    public BackBagViewer(Entity owner, int size, ItemStack[] default_content) {
        this(owner, size, default_content, null, false);
    }

    public BackBagViewer(Entity owner, int size, ItemStack[] default_content, String name, boolean temporary) {
        this(owner, size, default_content, name, temporary, false);
    }

    public BackBagViewer(Entity owner, int size, ItemStack[] default_content, String name, boolean temporary, boolean override) {
        this(owner, size, default_content, name, temporary, override, new ArrayList<Integer>());
    }

    public BackBagViewer(Entity owner, int size, ItemStack[] default_content, String name, boolean temporary, boolean override, List<Integer> excluded_slots) {
        ++backbag_counter;
        if (name == null) {
            name = BackBagHelper.str_name;
        }
        size = size % 9 > 0 ? size + (9 - size % 9) : size;
        this.owner = owner;
        if (override || (this.inventory = BackBagHelper.getBagInventory(owner.getUniqueId(), name)) == null) {
            this.inventory = new BackBagInventory(name, size, Bukkit.createInventory(null, (int)size, (String)name), temporary);
            BackBagHelper.addInventory(owner.getUniqueId(), this.inventory);
        }
        this.size = this.inventory.getInventory().getSize();
        this.name = this.inventory.getName();
        if (default_content != null && default_content.length <= this.size) {
            this.inventory.getInventory().setContents(default_content);
        }
        this.excludes_slots = excluded_slots;
    }

    public void viewBackBag(Player player) {
        this.viewBackBag(player, false, new ArrayList<Integer>());
    }

    public void viewBackBag(Player player, boolean bool) {
        this.viewBackBag(player, bool, new ArrayList<Integer>());
    }

    public void viewBackBag(Player player, boolean bool, List<Integer> excludes_slots) {
        this.only_view = bool;
        this.excludes_slots = excludes_slots;
        Main.pluginmanager.registerEvents((Listener)this, (Plugin)Main.getPlugin());
        this.viewer = player;
        player.openInventory(this.inventory.getInventory());
    }

    public boolean isPresent() {
        return this.inventory != null;
    }

    public int getSize() {
        return this.inventory.getSize();
    }

    public Inventory getInventory() {
        return this.inventory.getInventory();
    }

    public void setInventory(String name, Inventory new_inv) {
        this.inventory.setInventory(name, new_inv);
        this.size = new_inv.getSize();
        BackBagHelper.replace(this.owner.getUniqueId(), new BackBagInventory(this.name, this.size, this.inventory.getInventory()));
    }

    void executeSkill(String skill_name, Entity owner, Player viewer) {
        Optional maybe_skill = Utils.mythicmobs.getSkillManager().getSkill(skill_name);
        if (maybe_skill.isPresent()) {
            Skill skill = (Skill)maybe_skill.get();
            AbstractPlayer abstract_target = BukkitAdapter.adapt((Player)viewer);
            SkillMetadata data = new SkillMetadata(SkillTrigger.API, (SkillCaster)new GenericCaster(BukkitAdapter.adapt((Entity)owner)), (AbstractEntity)abstract_target);
            data.setEntityTarget((AbstractEntity)abstract_target);
            if (skill.isUsable(data)) {
                skill.execute(data);
            }
        }
    }

    @EventHandler
    public void ownerDeath(EntityDeathEvent e) {
        LivingEntity entity = e.getEntity();
        if (entity.getType() != EntityType.PLAYER && entity == this.owner) {
            this.viewer.closeInventory();
        }
    }

    @EventHandler
    public void ownerQuit(PlayerQuitEvent e) {
        if (e.getPlayer() == this.owner) {
            this.viewer.closeInventory();
        }
    }

    @EventHandler
    public void inventoryOpen(InventoryOpenEvent e) {
        if (e.isCancelled() && e.getInventory().equals(this.inventory.getInventory())) {
            HandlerList.unregisterAll((Listener)this);
        }
    }

    @EventHandler
    public void drag(InventoryDragEvent e) {
        if (e.getWhoClicked() == this.viewer && this.only_view) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void interact(InventoryClickEvent e) {
        if (e.getWhoClicked() == this.viewer) {
            if (this.only_view && !this.excludes_slots.contains(e.getRawSlot())) {
                e.setCancelled(true);
            }
            if (e.getClickedInventory() != null && e.getView().getTitle().equals(this.name)) {
                this.owner.setMetadata("lastclickedslot", (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), (Object)e.getRawSlot()));
                this.owner.setMetadata("lastclickedbag", (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), (Object)this.name));
                e.getWhoClicked().setMetadata("lastclickedslot", (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), (Object)e.getRawSlot()));
                if (Utils.mobmanager.isActiveMob(this.owner.getUniqueId())) {
                    ActiveMob am = Utils.mobmanager.getMythicMobInstance(this.owner);
                    am.signalMob(BukkitAdapter.adapt((Entity)e.getWhoClicked()), "BAGCLICKED");
                }
            }
            ItemStack clicked_stack = e.getCurrentItem();
            ItemStack current_stack = e.getCursor();
            if (clicked_stack != null) {
                if (NMSUtils.hasMeta(clicked_stack, "click_skill")) {
                    this.executeSkill(NMSUtils.getMetaString(clicked_stack, "click_skill"), this.owner, this.viewer);
                }
                if (NMSUtils.hasMeta(clicked_stack, "view_only")) {
                    e.setCancelled(NMSUtils.getMetaBoolean(clicked_stack, "view_only", false));
                }
            }
            if (current_stack != null && (clicked_stack == null || clicked_stack.getType() == Material.AIR)) {
                if (NMSUtils.hasMeta(current_stack, "click_skill")) {
                    this.executeSkill(NMSUtils.getMetaString(current_stack, "click_skill"), this.owner, this.viewer);
                }
                if (NMSUtils.hasMeta(current_stack, "view_only")) {
                    e.setCancelled(NMSUtils.getMetaBoolean(current_stack, "view_only", false));
                }
            }
        }
    }

    @EventHandler
    public void inventoryClose(InventoryCloseEvent e) {
        if (e.getPlayer() == this.viewer && e.getInventory().equals(this.inventory.getInventory())) {
            HandlerList.unregisterAll((Listener)this);
        }
    }

    protected void finalize() throws Throwable {
        --backbag_counter;
        super.finalize();
    }
}

