/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.bossbars.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.bossbars.BossBars;
import com.gmail.berndivader.mythicmobsext.bossbars.SegmentedEnum;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;

public class CreateBossBar
extends SkillMechanic
implements ITargetedEntitySkill {
    PlaceholderString title;
    PlaceholderString expr;
    BarStyle style;
    BarColor color;
    List<BarFlag> flags;
    int flags_size;

    public CreateBossBar(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.title = mlc.getPlaceholderString("title", "Bar");
        this.style = BarStyle.valueOf((String)SegmentedEnum.real(mlc.getInteger("segment", 6)).name());
        this.expr = mlc.getPlaceholderString("value", "0.05d");
        try {
            this.color = BarColor.valueOf((String)mlc.getString("color", "RED").toUpperCase());
        }
        catch (Exception ex) {
            Main.logger.info(mlc.getString("color") + " is not valid for BarColor in " + skill);
            this.color = BarColor.RED;
        }
        this.flags = new ArrayList<BarFlag>();
        for (String parse : mlc.getString("flags", "").toUpperCase().split(",")) {
            if (parse.isEmpty()) continue;
            BarFlag flag = null;
            try {
                flag = BarFlag.valueOf((String)parse);
            }
            catch (Exception ex) {
                Main.logger.info(parse + " is no valid BarFlag in " + skill);
            }
            if (flag == null) continue;
            this.flags.add(flag);
        }
        this.flags_size = this.flags.size();
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity abstract_entity) {
        if (abstract_entity.isPlayer()) {
            Player player = (Player)abstract_entity.getBukkitEntity();
            BossBar bar = Bukkit.createBossBar((String)this.title.get((PlaceholderMeta)data, abstract_entity), (BarColor)this.color, (BarStyle)this.style, (BarFlag[])new BarFlag[0]);
            if (bar != null) {
                double default_value = 1.0;
                String parsed_expr = this.expr.get((PlaceholderMeta)data, abstract_entity);
                try {
                    default_value = Double.parseDouble(parsed_expr);
                }
                catch (Exception e) {
                    Main.logger.info(parsed_expr + " is not valid for double in " + this.line);
                    default_value = 0.0;
                }
                bar.setProgress(default_value);
                for (int i1 = 0; i1 < this.flags_size; ++i1) {
                    bar.addFlag(this.flags.get(i1));
                }
                BossBars.addBar(abstract_entity.getUniqueId(), bar);
                bar.addPlayer(player);
                return true;
            }
        }
        return false;
    }
}

