/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.compatibility.worldguard;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.compatibility.worldguard.WorldGuardUtils;
import com.gmail.berndivader.mythicmobsext.conditions.AbstractCustomCondition;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import java.util.Comparator;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

public class MemberRegion
extends AbstractCustomCondition
implements IEntityCondition {
    boolean debug;
    boolean use_priority;
    TestForEnum test_for;

    public MemberRegion(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.use_priority = mlc.getBoolean("usepriority", false);
        try {
            this.test_for = TestForEnum.valueOf(mlc.getString("member", TestForEnum.MEMBER.name()).toUpperCase());
        }
        catch (Exception ex) {
            Main.logger.warning("line has invalid member type using default");
            this.test_for = TestForEnum.MEMBER;
        }
    }

    public boolean check(AbstractEntity abstract_entity) {
        Entity entity = abstract_entity.getBukkitEntity();
        Location location = entity.getLocation();
        Set<ProtectedRegion> regions = WorldGuardUtils.getRegionsByLocation(location);
        if (regions != null) {
            if (this.use_priority) {
                ProtectedRegion region = regions.stream().max(Comparator.comparing(ProtectedRegion::getPriority)).get();
                return this.test_for == TestForEnum.OWNER ? this.checkForOwners(region, entity) : this.checkForMembers(region, entity);
            }
            for (ProtectedRegion region : regions) {
                if (!(this.test_for == TestForEnum.OWNER ? this.checkForOwners(region, entity) : this.checkForMembers(region, entity))) continue;
                return true;
            }
        }
        return false;
    }

    boolean checkForOwners(ProtectedRegion region, Entity entity) {
        return region.getOwners().getUniqueIds().contains(entity.getUniqueId());
    }

    boolean checkForMembers(ProtectedRegion region, Entity entity) {
        return region.getMembers().getUniqueIds().contains(entity.getUniqueId());
    }

    static enum TestForEnum {
        MEMBER,
        OWNER;

    }
}

