/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.conditions;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.backbags.BackBagHelper;
import com.gmail.berndivader.mythicmobsext.conditions.AbstractCustomCondition;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.items.HoldingItem;
import com.gmail.berndivader.mythicmobsext.jboolexpr.BooleanExpression;
import com.gmail.berndivader.mythicmobsext.jboolexpr.MalformedBooleanException;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.GenericCaster;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

@ExternalAnnotation(name="testitemfor,ownsitem,ownsitemsimple,iteminhand", author="BerndiVader")
public class HasItemCondition
extends AbstractCustomCondition
implements IEntityCondition {
    private String conditionLine;
    private String meta_var;
    private boolean store_result;
    private List<HoldingItem> holdinglist = new ArrayList<HoldingItem>();

    public HasItemCondition(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.meta_var = mlc.getString("var", "");
        this.store_result = !this.meta_var.isEmpty();
        String tmp = mlc.getString(new String[]{"list", "l"}, null, new String[0]);
        if (tmp == null) {
            tmp = "\"where=" + mlc.getString("where", "ANY");
            tmp = tmp + ";material=" + mlc.getString("material", "ANY");
            tmp = tmp + ";amount=" + mlc.getString("amount", ">0");
            tmp = tmp + ";slot=" + mlc.getString("slot", "-1");
            tmp = tmp + ";name=" + mlc.getString("name", "ANY");
            tmp = tmp + ";enchant=" + mlc.getString("enchant", "ANY");
            tmp = tmp + ";lore=" + mlc.getString("lore", "ANY");
            tmp = tmp + ";bagname=" + mlc.getString("bagname", BackBagHelper.str_name) + "\"";
            tmp = SkillString.unparseMessageSpecialChars((String)tmp);
        }
        this.conditionLine = SkillString.parseMessageSpecialChars((String)tmp);
        String[] list = tmp.split("&&|\\|\\|");
        for (int a2 = 0; a2 < list.length; ++a2) {
            String parse = list[a2];
            HoldingItem holding = new HoldingItem();
            parse = SkillString.parseMessageSpecialChars((String)parse);
            this.conditionLine = this.conditionLine.replaceFirst(Pattern.quote(parse), "\\$" + Integer.toString(a2));
            if (parse.startsWith("\"") && parse.endsWith("\"")) {
                HoldingItem.parse(parse.substring(1, parse.length() - 1), holding);
            }
            this.holdinglist.add(holding);
        }
    }

    public boolean check(AbstractEntity t) {
        if (t.isLiving()) {
            BooleanExpression be;
            String c = this.conditionLine;
            LivingEntity target = (LivingEntity)t.getBukkitEntity();
            for (int i1 = 0; i1 < this.holdinglist.size(); ++i1) {
                boolean bool = false;
                HoldingItem holding = this.holdinglist.get(i1).clone();
                SkillMetadata data = new SkillMetadata(SkillTrigger.API, (SkillCaster)new GenericCaster(t), t);
                holding.parseSlot(data, t);
                String bag_name = holding.getBagName();
                if (bag_name != null) {
                    holding.setBagName(PlaceholderString.of((String)bag_name).get((PlaceholderMeta)data, t));
                }
                List<ItemStack> contents = HoldingItem.getContents(holding, target);
                for (int i2 = 0; i2 < contents.size(); ++i2) {
                    bool = holding.stackMatch(contents.get(i2), false);
                    if (!bool) continue;
                    if (!this.store_result) break;
                    target.setMetadata(this.meta_var, (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), (Object)holding.getWhere().name()));
                    break;
                }
                c = c.replaceFirst("\\$" + Integer.toString(i1), Boolean.toString(bool));
            }
            try {
                be = BooleanExpression.readLR(c);
            }
            catch (MalformedBooleanException e) {
                Main.logger.warning("Invalid bool expression: " + this.conditionLine);
                return false;
            }
            return be.booleanValue();
        }
        return false;
    }
}

