/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.jboolexpr;

import com.gmail.berndivader.mythicmobsext.jboolexpr.Boolean;
import com.gmail.berndivader.mythicmobsext.jboolexpr.BooleanAndOperation;
import com.gmail.berndivader.mythicmobsext.jboolexpr.BooleanExpression;
import com.gmail.berndivader.mythicmobsext.jboolexpr.BooleanNotOperation;
import com.gmail.berndivader.mythicmobsext.jboolexpr.BooleanOrOperation;
import com.gmail.berndivader.mythicmobsext.jboolexpr.BooleanUtil;
import com.gmail.berndivader.mythicmobsext.jboolexpr.IBoolean;
import com.gmail.berndivader.mythicmobsext.jboolexpr.MalformedBooleanException;

final class BooleanExpressionLR
extends BooleanExpression {
    private String booleanExpression;
    private IBoolean iBoolean;

    BooleanExpressionLR(String newBooleanExpression) throws MalformedBooleanException {
        this.booleanExpression = newBooleanExpression;
        this.iBoolean = this.toIBoolean(BooleanUtil.validAndformat(newBooleanExpression), newBooleanExpression.length());
    }

    @Override
    public boolean booleanValue() {
        return this.iBoolean.booleanValue();
    }

    private IBoolean toIBoolean(String formatedBooleanExpression, int index) throws MalformedBooleanException {
        int lastChar = this.getLastChar(formatedBooleanExpression);
        if (new Character((char)lastChar).toString().matches("\\s")) {
            lastChar = 32;
        }
        String substring = this.getSubstringWithoutLastChar(formatedBooleanExpression);
        switch (lastChar) {
            case 32: {
                IBoolean boolWhitespace = this.toIBoolean(substring, index - 1);
                return boolWhitespace;
            }
            case 41: {
                String openToEnd = this.getFromOpenParenthesisToEnd(substring, index - 1);
                String beginToOpen = this.getFromBeginToOpenParenthesis(substring, index - 1);
                IBoolean boolOpenToEnd = this.toIBoolean(openToEnd, index - 1);
                IBoolean boolToClose = this.toIBoolean(boolOpenToEnd, beginToOpen, index - 1);
                return boolToClose;
            }
            case 84: {
                IBoolean boolTrue = this.toIBoolean(new Boolean(true), substring, index - 4);
                return boolTrue;
            }
            case 70: {
                IBoolean boolFalse = this.toIBoolean(new Boolean(false), substring, index - 5);
                return boolFalse;
            }
        }
        throw new MalformedBooleanException("Expected [ ' ', ), true, false ]", index, this.booleanExpression);
    }

    private IBoolean toIBoolean(IBoolean lastIBoolean, String formatedBooleanExpression, int index) throws MalformedBooleanException {
        int lastChar = this.getLastChar(formatedBooleanExpression);
        if (new Character((char)lastChar).toString().matches("\\s")) {
            lastChar = 32;
        }
        String substring = this.getSubstringWithoutLastChar(formatedBooleanExpression);
        switch (lastChar) {
            case 32: {
                IBoolean boolWhitespace = this.toIBoolean(lastIBoolean, substring, index - 1);
                return boolWhitespace;
            }
            case 46: {
                return lastIBoolean;
            }
            case 40: {
                IBoolean boolToOpen = this.toIBoolean(lastIBoolean, substring, index - 1);
                return boolToOpen;
            }
            case 124: {
                IBoolean boolFirstOr = this.toIBoolean(substring, index - 2);
                BooleanOrOperation boolOr = new BooleanOrOperation(boolFirstOr, lastIBoolean);
                return boolOr;
            }
            case 38: {
                IBoolean boolFirstAnd = this.toIBoolean(substring, index - 2);
                BooleanAndOperation boolAnd = new BooleanAndOperation(boolFirstAnd, lastIBoolean);
                return boolAnd;
            }
            case 33: {
                BooleanNotOperation boolNot = new BooleanNotOperation(lastIBoolean);
                IBoolean boolAll = this.toIBoolean(boolNot, substring, index - 1);
                return boolAll;
            }
        }
        throw new MalformedBooleanException("Expected [ ' ', ), ||, &&, ! ]", index, this.booleanExpression);
    }

    private char getLastChar(String formatedBooleanExpression) {
        if (formatedBooleanExpression.length() == 0) {
            return '.';
        }
        return formatedBooleanExpression.charAt(formatedBooleanExpression.length() - 1);
    }

    private String getSubstringWithoutLastChar(String formatedBooleanExpression) {
        if (formatedBooleanExpression == null || formatedBooleanExpression.length() == 0) {
            return "";
        }
        return formatedBooleanExpression.substring(0, formatedBooleanExpression.length() - 1);
    }

    private String getFromBeginToOpenParenthesis(String formatedBooleanExpression, int index) throws MalformedBooleanException {
        if (formatedBooleanExpression == null || formatedBooleanExpression.length() == 0) {
            return "";
        }
        int fromIndex = 0;
        int toIndex = this.getIndexOfOpenParenthesis(formatedBooleanExpression, index);
        return formatedBooleanExpression.substring(fromIndex, toIndex);
    }

    private String getFromOpenParenthesisToEnd(String formatedBooleanExpression, int index) throws MalformedBooleanException {
        if (formatedBooleanExpression == null || formatedBooleanExpression.length() == 0) {
            return "";
        }
        int fromIndex = this.getIndexOfOpenParenthesis(formatedBooleanExpression, index) + 1;
        int toIndex = formatedBooleanExpression.length();
        return formatedBooleanExpression.substring(fromIndex, toIndex);
    }

    private int getIndexOfOpenParenthesis(String formatedBooleanExpression, int index) throws MalformedBooleanException {
        int lastIndexOfOpenParenthesis = this.getLastIndexOf(formatedBooleanExpression, "(", formatedBooleanExpression.length());
        int lastIndexOfCloseParenthesis = this.getLastIndexOf(formatedBooleanExpression, ")", formatedBooleanExpression.length());
        while (lastIndexOfCloseParenthesis != -1 && lastIndexOfOpenParenthesis < lastIndexOfCloseParenthesis) {
            lastIndexOfOpenParenthesis = this.getLastIndexOf(formatedBooleanExpression, "(", lastIndexOfOpenParenthesis);
            lastIndexOfCloseParenthesis = this.getLastIndexOf(formatedBooleanExpression, ")", lastIndexOfCloseParenthesis);
        }
        if (lastIndexOfOpenParenthesis == -1) {
            int parenthesisIndex = index - (formatedBooleanExpression.length() - lastIndexOfCloseParenthesis);
            throw new MalformedBooleanException("Have a close parenthesis without an open parenthesis", parenthesisIndex, this.booleanExpression);
        }
        return lastIndexOfOpenParenthesis;
    }

    private int getLastIndexOf(String formatedBooleanExpression, String searchedString, int toIndex) {
        if (toIndex < 0) {
            return -1;
        }
        if (toIndex >= formatedBooleanExpression.length()) {
            return formatedBooleanExpression.lastIndexOf(searchedString);
        }
        String newFormatedBooleanExpression = formatedBooleanExpression.substring(0, toIndex);
        return newFormatedBooleanExpression.lastIndexOf(searchedString);
    }

    public String toString() {
        return this.iBoolean.toString();
    }
}

