/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.NMS.NMSUtils;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import com.gmail.berndivader.mythicmobsext.volatilecode.Volatile;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

@ExternalAnnotation(name="digout", author="BerndiVader")
public class DigOutMechanic
extends SkillMechanic
implements INoTargetSkill {
    long speed;
    int particle_amount;
    Sound sound;

    public DigOutMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.threadSafetyLevel = AbstractSkill.ThreadSafetyLevel.SYNC_ONLY;
        this.speed = mlc.getInteger("speed", 5);
        this.particle_amount = mlc.getInteger("amount", 5);
        try {
            this.sound = Sound.valueOf((String)mlc.getString("sound", "block_stone_hit").toUpperCase());
        }
        catch (Exception ex) {
            Main.logger.warning("Invalid sound type in " + skill + " reset to default");
            this.sound = Sound.BLOCK_STONE_HIT;
        }
    }

    public boolean cast(SkillMetadata data) {
        if (!data.getCaster().getEntity().isLiving()) {
            return false;
        }
        final LivingEntity entity = (LivingEntity)data.getCaster().getEntity().getBukkitEntity();
        Location particle_location = entity.getLocation().getBlock().getLocation();
        final Location location = particle_location.clone().add(0.5, 0.0, 0.5);
        final Block block = location.getBlock().getRelative(BlockFace.DOWN);
        if (block.isLiquid() || block.getType() == Material.AIR) {
            return false;
        }
        String particle_name = "blockcrack_" + block.getType().getId() + "_" + block.getData();
        final boolean gravity = entity.hasGravity();
        final boolean invulnerable = entity.isInvulnerable();
        NMSUtils.setEntityMotion((Entity)entity, new Vector(0, 0, 0));
        NMSUtils.setInvulnerable((Entity)entity, true);
        entity.setInvulnerable(true);
        entity.setGravity(false);
        double y = entity.getHeight() + 0.5;
        final double y_step = y / 10.0;
        location.subtract(0.0, y, 0.0);
        final double x = location.getX();
        final double z = location.getZ();
        entity.teleport(location);
        new BukkitRunnable(){
            int stage = 0;
            double delta_x;
            double delta_z;

            public void run() {
                if (entity == null || entity.isDead()) {
                    this.cancel();
                }
                Volatile.handler.playBlockBreak(entity.getEntityId(), block.getLocation(), this.stage);
                Volatile.handler.playAnimationPacket(entity, 0);
                location.getWorld().playSound(location, DigOutMechanic.this.sound, 1.5f, 1.0f);
                this.delta_x = Main.random.nextDouble();
                this.delta_z = Main.random.nextDouble();
                if (Utils.serverV < 13) {
                    // empty if block
                }
                if (this.stage > 9) {
                    NMSUtils.setInvulnerable((Entity)entity, invulnerable);
                    entity.setGravity(gravity);
                    this.cancel();
                }
                Location l = entity.getLocation();
                l.setX(x);
                l.setZ(z);
                l.add(0.0, y_step, 0.0);
                entity.teleport(l);
                ++this.stage;
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 1L, this.speed);
        return true;
    }
}

