/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.jboolexpr.MathInterpreter;
import com.gmail.berndivader.mythicmobsext.utils.RandomDouble;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@ExternalAnnotation(name="particleimage", author="Seyarada")
public class ParticleImage
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    String file;
    String backgroundColor;
    String resize;
    String transform;
    int loop;
    int skip;
    double scale;
    Long interval;
    PlaceholderString scaleAmount;
    Particle particle;

    public ParticleImage(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.file = mlc.getString(new String[]{"file", "f"}, null, new String[0]);
        this.scaleAmount = PlaceholderString.of((String)mlc.getString(new String[]{"scale", "s"}, "4", new String[0]));
        this.backgroundColor = mlc.getString(new String[]{"bgcolor", "color", "c"}, "white", new String[0]);
        this.resize = mlc.getString("resize", "false");
        this.interval = mlc.getLong("interval", 5L);
        this.skip = mlc.getInteger("skip", 5);
        this.transform = mlc.getString("transform", "x,0,y");
        this.particle = Particle.valueOf((String)mlc.getString(new String[]{"particle", "p"}, "REDSTONE", new String[0]).toUpperCase());
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity p) {
        this.scale = new RandomDouble(this.scaleAmount.get((PlaceholderMeta)data, p)).rollDouble();
        Location loc = BukkitAdapter.adapt((AbstractLocation)p.getLocation());
        this.start(loc);
        return true;
    }

    public boolean castAtLocation(SkillMetadata data, AbstractLocation aL) {
        AbstractEntity caster = data.getTrigger();
        this.scale = new RandomDouble(this.scaleAmount.get((PlaceholderMeta)data, caster)).rollDouble();
        Location loc = BukkitAdapter.adapt((AbstractLocation)aL);
        this.start(loc);
        return false;
    }

    public void start(final Location loc) {
        if (this.file.contains(".gif")) {
            File dir = new File(Main.getPlugin().getDataFolder().getPath() + "/images/" + this.file);
            try {
                final ArrayList<BufferedImage> frames = this.getFrames(dir);
                this.loop = 0;
                final int size = frames.size();
                new BukkitRunnable(){

                    public void run() {
                        if (ParticleImage.this.loop < size) {
                            ParticleImage.this.draw((BufferedImage)frames.get(ParticleImage.this.loop), loc);
                            ++ParticleImage.this.loop;
                        } else {
                            this.cancel();
                        }
                    }
                }.runTaskTimerAsynchronously((Plugin)Main.getPlugin(), 1L, this.interval.longValue());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            BufferedImage img = null;
            File dir = new File(Main.getPlugin().getDataFolder().getPath() + "/images/" + this.file);
            try {
                img = ImageIO.read(dir);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (img != null) {
                this.draw(img, loc);
            }
        }
    }

    public void draw(BufferedImage img, Location loc) {
        if (!this.resize.equals("false")) {
            String[] x = this.resize.split(",");
            int tWidth = Integer.parseInt(x[0]);
            int tHeight = Integer.parseInt(x[1]);
            try {
                img = this.resizeImage(img, tWidth, tHeight);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        double width = img.getWidth() - 1;
        double height = img.getHeight() - 1;
        World world = loc.getWorld();
        int k = 1;
        int i = 0;
        while ((double)i < width) {
            int o = 0;
            while ((double)o < height) {
                if (k >= this.skip) {
                    k = 1;
                    int pixel = img.getRGB(i, o);
                    int r = pixel >> 16 & 0xFF;
                    int g = pixel >> 8 & 0xFF;
                    int b = pixel & 0xFF;
                    int bgBlue = 255;
                    int bgGreen = 255;
                    int bgRed = 255;
                    if (!this.backgroundColor.equals("white") && !this.backgroundColor.contains(",")) {
                        bgRed = 0;
                        bgGreen = 0;
                        bgBlue = 0;
                    } else if (this.backgroundColor.contains(",")) {
                        String[] colors = this.backgroundColor.split(",");
                        bgRed = Integer.parseInt(colors[0]);
                        bgGreen = Integer.parseInt(colors[1]);
                        bgBlue = Integer.parseInt(colors[2]);
                    }
                    if (r != bgRed && g != bgGreen && b != bgBlue) {
                        double x = (double)i / this.scale - width / this.scale / 2.0;
                        double y = (double)o / this.scale - height / this.scale / 2.0;
                        String t1 = this.transform.split(",")[0];
                        String t2 = this.transform.split(",")[1];
                        String t3 = this.transform.split(",")[2];
                        t1 = t1.replace("x", String.valueOf(x)).replace("y", String.valueOf(y));
                        t2 = t2.replace("x", String.valueOf(x)).replace("y", String.valueOf(y));
                        t3 = t3.replace("x", String.valueOf(x)).replace("y", String.valueOf(y));
                        double result1 = MathInterpreter.parse(t1, new HashMap<String, Double>()).eval();
                        double result2 = MathInterpreter.parse(t2, new HashMap<String, Double>()).eval();
                        double result3 = MathInterpreter.parse(t3, new HashMap<String, Double>()).eval();
                        Location finalLoc = loc.clone();
                        finalLoc.add(result1, result2, result3);
                        if (this.particle == Particle.valueOf((String)"REDSTONE")) {
                            Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)r, (int)g, (int)b), 1.0f);
                            world.spawnParticle(Particle.REDSTONE, finalLoc, 1, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions);
                        } else {
                            world.spawnParticle(this.particle, finalLoc, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                } else {
                    ++k;
                }
                ++o;
            }
            ++i;
        }
    }

    public ArrayList<BufferedImage> getFrames(File gif) throws IOException {
        ArrayList<BufferedImage> frames = new ArrayList<BufferedImage>();
        try {
            String[] imageatt = new String[]{"imageLeftPosition", "imageTopPosition", "imageWidth", "imageHeight"};
            ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
            ImageInputStream ciis = ImageIO.createImageInputStream(gif);
            reader.setInput(ciis, false);
            int noi = reader.getNumImages(true);
            BufferedImage master = null;
            for (int i = 0; i < noi; ++i) {
                BufferedImage image = reader.read(i);
                IIOMetadata metadata = reader.getImageMetadata(i);
                Node tree = metadata.getAsTree("javax_imageio_gif_image_1.0");
                NodeList children = tree.getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    Node nodeItem = children.item(j);
                    if (!nodeItem.getNodeName().equals("ImageDescriptor")) continue;
                    HashMap<String, Integer> imageAttr = new HashMap<String, Integer>();
                    for (int k = 0; k < imageatt.length; ++k) {
                        NamedNodeMap attr = nodeItem.getAttributes();
                        Node attnode = attr.getNamedItem(imageatt[k]);
                        imageAttr.put(imageatt[k], Integer.valueOf(attnode.getNodeValue()));
                    }
                    if (i == 0) {
                        master = new BufferedImage((Integer)imageAttr.get("imageWidth"), (Integer)imageAttr.get("imageHeight"), 2);
                    }
                    master.getGraphics().drawImage(image, (Integer)imageAttr.get("imageLeftPosition"), (Integer)imageAttr.get("imageTopPosition"), null);
                }
                File dir = new File(Main.getPlugin().getDataFolder().getPath() + "/images/qlJ06jLEg8.png");
                ImageIO.write(master, "GIF", dir);
                BufferedImage a = ImageIO.read(dir);
                frames.add(a);
                dir.delete();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return frames;
    }

    BufferedImage resizeImage(BufferedImage originalImage, int targetWidth, int targetHeight) throws IOException {
        Image resultingImage = originalImage.getScaledInstance(targetWidth, targetHeight, 1);
        BufferedImage outputImage = new BufferedImage(targetWidth, targetHeight, 1);
        outputImage.getGraphics().drawImage(resultingImage, 0, 0, null);
        return outputImage;
    }
}

