/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.compatibility.worldguard;

import com.gmail.berndivader.mythicmobsext.compatibility.worldguard.WorldGuardUtils;
import com.gmail.berndivader.mythicmobsext.conditions.AbstractCustomCondition;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class WorldGuardRegionCondition
extends AbstractCustomCondition
implements ILocationCondition {
    List<String> region_names;
    boolean debug;
    boolean use_priority;

    public WorldGuardRegionCondition(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.region_names = Arrays.asList(mlc.getString(new String[]{"regions", "region", "r"}, new String(), new String[0]).split(","));
        this.use_priority = mlc.getBoolean("usepriority", false);
    }

    public boolean check(AbstractLocation al) {
        Set<ProtectedRegion> regions = WorldGuardUtils.getRegionsByLocation(BukkitAdapter.adapt((AbstractLocation)al));
        if (regions != null) {
            if (this.use_priority) {
                ProtectedRegion region = regions.stream().max(Comparator.comparing(ProtectedRegion::getPriority)).get();
                if (this.region_names.contains(region.getId())) {
                    return true;
                }
            } else {
                for (ProtectedRegion region : regions) {
                    if (!this.region_names.contains(region.getId())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

